/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RegistryConfig.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

/**
 * @author ofabre
 * 
 */
public class RegistryConfig {

    private final static String REGISTRY_PROPERTIES_FILE_NAME = "dragon.properties";

    public final static String CONFIGURATION_RELOAD_DELAY = "configuration.reload.delay";

    private Logger log = Logger.getLogger(RegistryConfig.class);

    private Configuration config;

    private static RegistryConfig instance = null;

    /**
     * Does the actual work of reading the configuration from System Properties
     * and/or dragon.properties file. When the dragon.properties file is updated
     * the file will be reloaded. By default the reloadDelay is set to 1 second
     * to prevent excessive date stamp checking.
     */
    private void loadConfiguration() throws ConfigurationException {
        // Properties from system properties
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration(new SystemConfiguration());
        // Properties from file
        PropertiesConfiguration propConfig = new PropertiesConfiguration(
                REGISTRY_PROPERTIES_FILE_NAME);
        long refreshDelay = propConfig.getLong(CONFIGURATION_RELOAD_DELAY, 1000l);
        log.debug("Setting refreshDelay to " + refreshDelay);
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        propConfig.setReloadingStrategy(fileChangedReloadingStrategy);
        compositeConfig.addConfiguration(propConfig);

        // Making the new configuration globally accessible.
        config = compositeConfig;
    }

    private RegistryConfig() throws ConfigurationException {
        super();
        loadConfiguration();
    }

    public static RegistryConfig getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new RegistryConfig();
        }
        return instance;
    }

    /**
     * The object from which property values can be obtained.
     * 
     * @return the commons Configuration interface
     * @throws ConfigurationException
     */
    public static Configuration getConfiguration() throws ConfigurationException {
        return getInstance().config;
    }

}
