/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SearchHelper.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author ambarthe, ofabre - eBM WebSourcing
 * 
 */
public class SearchHelper {

    // Not allowed characters (defined by lucene)
    private static final String regSymbol1 = "\\u002b+"; // escape "+"

    private static final String regSymbol2 = "\\u002d+"; // escape "-"

    private static final String regSymbol3 = "\\u0026+"; // escape "&"

    private static final String regSymbol4 = "\\u007c+"; // escape "|"

    private static final String regSymbol5 = "\\u0021+"; // escape "!"

    private static final String regSymbol6 = "\\u0028+"; // escape "("

    private static final String regSymbol7 = "\\u0029+"; // escape ")"

    private static final String regSymbol8 = "\\u007b+"; // escape "{"

    private static final String regSymbol9 = "\\u007d+"; // escape "}"

    private static final String regSymbol10 = "\\u005b+"; // escape "["

    private static final String regSymbol11 = "\\u005d+"; // escape "]"

    private static final String regSymbol12 = "\\u005e+"; // escape "^"

    private static final String regSymbol13 = "\\u0022+"; // escape """

    private static final String regSymbol14 = "\\u003a+"; // escape ":"

    // Allowed characters (defined by lucene)
    private static final String regSymbol15 = "\\u007e+"; // escape "~"

    private static final String regSymbol16 = "\\u002a+"; // escape "*"

    private static final String regSymbol17 = "\\u003f+"; // escape "?"

    private static final String regSymbol18 = "\\u005c+"; // escape "\"

    private static final String regSymbol22 = "\\u002f+"; // escape "/"

    // Spaces

    private static final String regSymbol19 = "\\s+"; // escape multiple spaces

    private static final String regSymbol20 = "^\\s"; // escape spaces at the

    // beginning...

    private static final String regSymbol21 = "\\s+$//"; // ...and in the end

    // String spaces

    private static final String space = " ";

    private static final String noSpace = "";

    public static String[] splitSearchCriteria(String searchCriteria) {
        List<String> result = new ArrayList<String>();
        String[] keyword_list = null;
        if (!StringHelper.isNullOrEmpty(searchCriteria)) {
            // Escape all "exotic" characters from the search criteria
            searchCriteria = searchCriteria.replaceAll(regSymbol1, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol2, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol3, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol4, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol5, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol6, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol7, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol8, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol9, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol10, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol11, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol12, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol13, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol14, space);

            // Escape slash character (/) to allow search on service full Qname
            searchCriteria = searchCriteria.replaceAll(regSymbol22, space);

            // Fix spaces
            searchCriteria = searchCriteria.replaceAll(regSymbol19, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol20, noSpace);
            searchCriteria = searchCriteria.replaceAll(regSymbol21, noSpace);

            // ... and parse $search_criteria into an array of keywords based on
            // word boundary (\s+ splits on whitespace)
            keyword_list = searchCriteria.split("\\s");

            // Check that tilde character (~) is used properly : at the end
            // of a word and not at the beginning, middle or alone
            for (String string : keyword_list) {
                if ((string != null && !(string.contains("~")))
                        || (string != null && !(string.contains("~") && !Pattern.compile(
                                "\\b\\w+~(0?|1?|(0\\.\\d)?)").matcher(string).matches()))) {
                    result.add(string);
                } else {
                    // Simply remove the "~" before adding the criteria
                    string = string.replaceAll(regSymbol15, noSpace);
                    result.add(string);
                }
            }

            // searchCriteria =
            // searchCriteria.replaceAll("\\b\\w+~(0?|1?|(0\\.\\d)?)",
            // space);

        }
        return result.toArray(new String[0]);
    }

}
