/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentType {
    DOC("application/msword"),
    PDF("application/pdf"),
    HTML("text/html"),
    XML("text/xml"),
    XLS("application/vnd.ms-excel"),
    PPT("application/vnd.ms-powerpoint"),
    TXT("text/plain"),
    RTF("application/rtf"),
    ODT("application/vnd.oasis.opendocument.text"),
    ODS("application/vnd.oasis.opendocument.spreadsheet"),
    ODP("application/vnd.oasis.opendocument.presentation");

    private final String type;
    private static final Map<String, ContentType> stringToEnum;

    private ContentType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public static ContentType fromString(String type) {
        return stringToEnum.get(type);
    }

    public static String getRelatedSuffix(ContentType type) {
        String suffix = null;
        if (type != null) {
            switch (type) {
                case XML: {
                    suffix = ".xml";
                    break;
                }
                case DOC: {
                    suffix = ".doc";
                    break;
                }
                case HTML: {
                    suffix = ".html";
                    break;
                }
                case PDF: {
                    suffix = ".pdf";
                    break;
                }
                case XLS: {
                    suffix = ".xls";
                    break;
                }
                case PPT: {
                    suffix = ".ppt";
                    break;
                }
                case TXT: {
                    suffix = ".txt";
                    break;
                }
                case RTF: {
                    suffix = ".rtf";
                    break;
                }
                case ODT: {
                    suffix = ".odt";
                    break;
                }
                case ODP: {
                    suffix = ".odp";
                    break;
                }
                case ODS: {
                    suffix = ".ods";
                    break;
                }
                default: {
                    suffix = null;
                }
            }
        }
        return suffix;
    }

    static {
        stringToEnum = new HashMap<String, ContentType>();
        for (ContentType type : ContentType.values()) {
            stringToEnum.put(type.toString(), type);
        }
    }
}

