/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AbstractTimeout.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import java.util.concurrent.TimeoutException;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public abstract class AbstractTimeout<T> {

    private class TimeoutThread implements Runnable {
        public void run() {
            T res = command();
            synchronized (AbstractTimeout.this) {
                if (timedOut && res != null) {
                } else {
                    result = res;
                    AbstractTimeout.this.notify();
                }
            }
        }
    }

    private boolean timedOut = false;

    private T result = null;

    protected AbstractTimeout() {
    }

    public synchronized T execute(int timeout) throws TimeoutException {
        new Thread(new TimeoutThread()).start();

        try {
            this.wait(timeout);
        } catch (InterruptedException e) {
            if (result == null) {
                timedOut = true;
            } else {
                commandTimeOut(result);
            }
            throw new TimeoutException("timed out occured");
        }

        if (result != null) {
            return result;
        } else {
            timedOut = true;
            throw new TimeoutException("timed out occured");
        }
    }

    /**
     * Method executed if timout occured but result is ok
     * 
     * @param result
     *            the result object
     */
    protected abstract void commandTimeOut(T result);

    /**
     * Method to execute with a timeout limit
     * 
     * @return the result Object
     */
    protected abstract T command();
}
