/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ContentType.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

/**
 * A list of UDDI V3 Standard TModels IDs
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class UDDIStandardTModelKeys {
    // Base tmodels
    public static final String CATEGORIZATION_TYPES = "uddi:uddi.org:categorization:types";

    public static final String CATEGORIZATION_GENERAL_KEYWORDS = "uddi:uddi.org:categorization:general_keywords";

    public static final String CATEGORIZATION_NODES = "uddi:uddi.org:categorization:nodes";

    public static final String RELATION_SHIPS = "uddi:uddi.org:relationships";

    public static final String CATEGORIZATION_OWNINGBUSINESS = "uddi:uddi.org:categorization:owningbusiness";

    public static final String IDENTIFIER_ISREPLACEDBY = "uddi:uddi.org:identifier:isreplacedby";

    public static final String CATEGORIZATION_VALIDATEDBY = "uddi:uddi.org:categorization:validatedby";

    public static final String CATEGORIZATION_DERIVEDFROM = "uddi:uddi.org:categorization:derivedfrom";

    public static final String CATEGORIZATION_ENTITYKEYVALUES = "uddi:uddi.org:categorization:entitykeyvalues";

    // Protocol tmodels
    public static final String PROTOCOL_SERVERAUTHENTICATEDSSL3 = "uddi:uddi.org:protocol:serverauthenticatedssl3";

    public static final String PROTOCOL_MUTUALAUTHENTICATEDSSL3 = "uddi:uddi.org:protocol:mutualauthenticatedssl3";

    public static final String TRANSPORT_HTTP = "uddi:uddi.org:transport:http";

    public static final String TRANSPORT_SMTP = "uddi:uddi.org:transport:smtp";

    public static final String TRANSPORT_FTP = "uddi:uddi.org:transport:ftp";

    public static final String TRANSPORT_FAX = "uddi:uddi.org:transport:fax";

    public static final String TRANSPORT_TELEPHONE = "uddi:uddi.org:transport:telephone";

    // Categorization tmodel
    public static final String UBR_CATEGORIZATION_NAICS_1997 = "uddi:uddi.org:ubr:categorization:naics:1997";

    public static final String UBR_CATEGORIZATION_NAICS_2002 = "uddi:uddi.org:ubr:categorization:naics:2002";

    public static final String UBR_CATEGORIZATION_UNSPSC = "uddi:uddi.org:ubr:categorization:unspsc";

    public static final String UBR_CATEGORIZATION_ISO3166 = "uddi:uddi.org:ubr:categorization:iso3166";

    // Identitifer tmodels
    public static final String UBR_IDENTIFIER_DUNS = "uddi:uddi.org:ubr:identifier:dnb.com:d-u-n-s";

    public static final String UBR_IDENTIFIER_THOMASREGISTER = "uddi:uddi.org:ubr:identifier:thomasregister.com:supplierid";

    public static final String UBR_IDENTIFIER_ISO6523ICD = "uddi:uddi.org:ubr:identifier:iso6523icd";

    // UDDI API tmodels
    public static final String V3_INQUIRY = "uddi:uddi.org:v3_inquiry";

    public static final String V3_PUBLICATION = "uddi:uddi.org:v3_publication";

    // WSDL mapping to model
    public static final String WSDL_TYPES = "uddi:uddi.org:wsdl:types";

    public static final String XML_NAMESPACE = "uddi:uddi.org:xml:namespace";

    public static final String XML_LOCALNAME = "uddi:uddi.org:xml:localname";

    public static final String WSDL_PORTTYPEREFERENCE = "uddi:uddi.org:wsdl:porttypereference";

    public static final String PROTOCOL_SOAP = "uddi:uddi.org:protocol:soap";

    public static final String PROTOCOL_SOAP12 = "uddi:dragon.org:protocol:soap12";

    public static final String PROTOCOL_HTTP = "uddi:uddi.org:protocol:http";

    public static final String WSDL_CATEGORIZATION_PROTOCOL = "uddi:uddi.org:wsdl:categorization:protocol";

    public static final String WSDL_CATEGORIZATION_TRANSPORT = "uddi:uddi.org:wsdl:categorization:transport";

    public static final String WSDL_ADDRESS = "uddi:uddi.org:wsdl:address";
}
