/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.util;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;

public class RegistryConfig {
    private static final String REGISTRY_PROPERTIES_FILE_NAME = "dragon.properties";
    public static final String CONFIGURATION_RELOAD_DELAY = "configuration.reload.delay";
    private Logger log = Logger.getLogger(RegistryConfig.class);
    private Configuration config;
    private static RegistryConfig instance = null;

    private void loadConfiguration() throws ConfigurationException {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        PropertiesConfiguration propConfig = new PropertiesConfiguration(REGISTRY_PROPERTIES_FILE_NAME);
        long refreshDelay = propConfig.getLong(CONFIGURATION_RELOAD_DELAY, 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        propConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)propConfig);
        this.config = compositeConfig;
    }

    private RegistryConfig() throws ConfigurationException {
        this.loadConfiguration();
    }

    public static RegistryConfig getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new RegistryConfig();
        }
        return instance;
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        return RegistryConfig.getInstance().config;
    }
}

