/**
 * 
 */

package org.ow2.dragon.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.SpringUtil;

/**
 * @author Olivier
 * 
 */
public class RepositoryServlet extends HttpServlet {

    /**
	 * 
	 */
    private static final long serialVersionUID = 3069362997017015761L;

    private Logger logger = Logger.getLogger(this.getClass());

    private MetadataService metadataService;

    @Override
    public void init() throws ServletException {
        metadataService = (MetadataService) SpringUtil
                .getWebApplicationContext(getServletContext()).getBean("metadataService");
        boolean cleanup = Boolean.parseBoolean(getInitParameter("cleanup"));
        if (cleanup) {
            logger.info("Cleanup file repository");
            this.metadataService.cleanupRepository();
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException,
            IOException {
        String fileId = req.getParameter("fileId");

        // The file metadata (title, mimetype...)
        SimpleFile simpleFile = metadataService.loadMetadata(fileId);

        // The file content
        InputStream input = null;
        try {
            input = metadataService.loadMetadataContentAsInputStream(fileId);
        } catch (Exception e) {
            throw new ServletException(e);
        }
        OutputStream output = resp.getOutputStream();

        resp.setContentType(simpleFile.getFileType().toString());
        resp.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
        resp.setHeader("Pragma", "no-cache"); // HTTP 1.0
        resp.setDateHeader("Expires", 0); // prevents caching at the proxy

        InputStreamUtil.copy(input, output);
        input.close();
        output.close();
    }

}
