/***
 * OW2 FraSCAti Examples: Soap Calculator Client
 * Copyright (C) 2009 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Nicolas Dolet
 *
 * Contributor(s):
 */

package org.ow2.frascati.examples.soapcalc.api;

import org.osoa.sca.annotations.Service;

/**
 * Interface for the FraSCAti calculator service.
 */
@Service
public interface Calculator {
  
  public int add(String i, String j);
  public int sub(String i, String j);
  public int mult(String i, String j);
  public double div(String i, String j);
}
