/*
 * Decompiled with CFR 0.152.
 */
package examples.chat;

import examples.chat.Chat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;

@Scope(value="COMPOSITE")
public class ClientImpl
implements Runnable {
    @Property
    private String header = "> ";
    @Reference
    public Chat chatService;

    private void printMessages(String messages) {
        StringTokenizer st = new StringTokenizer(messages, "\n");
        while (st.hasMoreTokens()) {
            System.out.println(this.header + st.nextToken());
        }
    }

    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String msg = null;
        String previousMessages = "";
        System.out.println("Chat client ready!");
        do {
            try {
                msg = br.readLine();
                this.chatService.sendMessage(System.getProperty("user.name"), msg);
            }
            catch (IOException ioe) {
                System.out.println("IO error!");
                System.exit(1);
            }
            msg = this.chatService.getMessages();
            this.printMessages(msg.substring(previousMessages.length()));
            previousMessages = msg;
        } while (msg != null);
    }
}

