/*
 * Decompiled with CFR 0.152.
 */
package examples.chat.client.gui;

import examples.chat.client.gui.ChatAboutBox;
import examples.chat.client.gui.ChatGUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class ChatView
extends FrameView {
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JTextField message;
    private JTextArea messagesArea;
    private JScrollPane messagesPane;
    private JProgressBar progressBar;
    private JTextField pseudo;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messagesAreaTimer;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public ChatView(SingleFrameApplication app) {
        super((Application)app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatView.this.busyIconIndex = (ChatView.this.busyIconIndex + 1) % ChatView.this.busyIcons.length;
                ChatView.this.statusAnimationLabel.setIcon(ChatView.this.busyIcons[ChatView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ChatView.this.busyIconTimer.isRunning()) {
                        ChatView.this.statusAnimationLabel.setIcon(ChatView.this.busyIcons[0]);
                        ChatView.this.busyIconIndex = 0;
                        ChatView.this.busyIconTimer.start();
                    }
                    ChatView.this.progressBar.setVisible(true);
                    ChatView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ChatView.this.busyIconTimer.stop();
                    ChatView.this.statusAnimationLabel.setIcon(ChatView.this.idleIcon);
                    ChatView.this.progressBar.setVisible(false);
                    ChatView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ChatView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ChatView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ChatView.this.progressBar.setVisible(true);
                    ChatView.this.progressBar.setIndeterminate(false);
                    ChatView.this.progressBar.setValue(value);
                }
            }
        });
        int messagesAreaTimeout = resourceMap.getInteger("messagesArea.timeout");
        this.messagesAreaTimer = new Timer(messagesAreaTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatView.this.messagesArea.setText(ChatGUI.getChatService().getMessages());
            }
        });
        this.messagesAreaTimer.start();
        this.pseudo.setText(System.getProperty("user.name"));
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ChatGUI.getApplication().getMainFrame();
            this.aboutBox = new ChatAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ChatGUI.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.message = new JTextField();
        this.messagesPane = new JScrollPane();
        this.messagesArea = new JTextArea();
        this.pseudo = new JTextField();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = ((ChatGUI)Application.getInstance(ChatGUI.class)).getContext().getResourceMap(ChatView.class);
        this.message.setText(resourceMap.getString("message.text", new Object[0]));
        this.message.setName("message");
        this.message.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatView.this.messageActionPerformed(evt);
            }
        });
        this.messagesPane.setName("messagesPane");
        this.messagesArea.setColumns(20);
        this.messagesArea.setEditable(false);
        this.messagesArea.setRows(5);
        this.messagesArea.setName("messagesArea");
        this.messagesPane.setViewportView(this.messagesArea);
        this.pseudo.setColumns(10);
        this.pseudo.setEditable(false);
        this.pseudo.setText(resourceMap.getString("pseudo.text", new Object[0]));
        this.pseudo.setAutoscrolls(false);
        this.pseudo.setName("pseudo");
        this.pseudo.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ChatView.this.pseudoFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ChatView.this.pseudoFocusLost(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2).add(1, (Component)this.messagesPane, -1, 376, Short.MAX_VALUE).add(1, (Component)this.message, -1, 376, Short.MAX_VALUE).add(1, (Component)this.pseudo, -2, -1, -2)).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.messagesPane, -1, 186, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pseudo, -2, -1, -2).add(2, 2, 2).add((Component)this.message, -2, -1, -2).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = ((ChatGUI)Application.getInstance(ChatGUI.class)).getContext().getActionMap(ChatView.class, (Object)this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((Component)statusPanelSeparator, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.statusMessageLabel).addPreferredGap(0, 216, Short.MAX_VALUE).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createParallelGroup(3).add((Component)this.statusMessageLabel).add((Component)this.statusAnimationLabel).add((Component)this.progressBar, -2, -1, -2)).add(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void messageActionPerformed(ActionEvent evt) {
        ChatGUI.getChatService().sendMessage(this.pseudo.getText(), this.message.getText());
        this.message.setText("");
    }

    private void pseudoFocusGained(FocusEvent evt) {
        this.pseudo.setEditable(true);
    }

    private void pseudoFocusLost(FocusEvent evt) {
        this.pseudo.setEditable(false);
    }

    public void updateMessages(String messages) {
        this.messagesArea.setText(messages);
    }
}

