/***
 * OW2 FraSCAti examples: chat
 * Copyright (C) 2008 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Contact: frascati@ow2.org 
 *
 * Author(s): Christophe Demarey
 */

package examples.chat;

/**
 * The chat Server interface.
 * 
 * @author Christophe Demarey.
 */
public interface Chat {
    /**
     * Initialize a connection with the chat server.
     */
    public void connect();
    
    /**
     * Leave the chat.
     */
    public void disconnect();

    /**
     * Get all messages received by the chat server.
     * 
     * @return The list of received messages.
     */
    public String getMessages();

    /**
     * Send a message to the chat server
     * 
     * @param pseudo - The pseudo of the sender.
     * @param msg - The message to send.
     */
    public void sendMessage(String pseudo, String msg);
}
