/***
 * OW2 FraSCAti Examples : chat
 * Copyright (C) 2008-2009 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Contact: frascati@ow2.org 
 *
 * Author(s): Christophe Demarey
 * 
 * Contributor(s): Nicolas Dolet
 */

package examples.chat.client.gui;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.factory.Factory;
import org.ow2.frascati.factory.FactoryException;
import org.ow2.frascati.factory.FactoryInstantiationException;
import org.ow2.frascati.tinfi.TinfiDomain;

import examples.chat.Chat;

/**
 * The main class of the GUI.
 * It implements the ChatServer interface in order to provide
 * SCA service to the GUI.
 */
@Scope("COMPOSITE")
public class ChatGUI 
     extends SingleFrameApplication 
     implements Runnable {
    /** A reference to the Chat service. */
    protected static Chat service;
    /** Logger for this class */
    protected static Logger log = Logger.getLogger("examples.chat.client.gui.ChatGUI");

    /**
     * Default constructor.
     */
    public ChatGUI() { }
    
    /**
     * At startup create and show the main frame of the application.
     */
    @Override protected void startup() {
      show(new ChatView(this));
    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) {
    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of ChatGUI
     */
    public static ChatGUI getApplication() {
      return Application.getInstance(ChatGUI.class);
    }

    /**
     * A convenient static getter for the chat service.
     * @return the reference for the chat service.
     */
    public static Chat getChatService() {
      return getApplication().service;
    }

    /**
     * 
     */
    public void run() {
      launch(ChatGUI.class, new String[0]);  
    }

    /**
     * Main method launching the application.
     * @throws FactoryException if the composite cannot be loaded
     * @throws FactoryInstantiationException if the SCA factory cannot be loade
     */
    public static void main(String[] args) throws FactoryException, FactoryInstantiationException {
      // Instantiate the client composite
      String compositeName = "chat-gui-client",
             serviceName = "chatService";
    
      Component c = new Factory().getComposite(compositeName);
      
      try {
        service = TinfiDomain.getService(c, Chat.class, serviceName);
      } catch(NoSuchInterfaceException nsie) {
        log.log(Level.SEVERE, "The SCA composite '" + compositeName + "' has no service '" + serviceName + "'!", nsie);
      } 
      
      // Run the GUI
      launch(ChatGUI.class, args);
    }

}
