/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.comanche;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.ow2.frascati.examples.comanche.HandlerType;
import org.ow2.frascati.examples.comanche.Request;
import org.ow2.frascati.examples.comanche.RequestHandler;

public class RequestDispatcher
implements RequestHandler {
    @Reference
    private List<RequestHandler> rh = new ArrayList<RequestHandler>();

    @Init
    public final void init() {
        ArrayList<RequestHandler> fileList = new ArrayList<RequestHandler>();
        ArrayList<RequestHandler> errorList = new ArrayList<RequestHandler>();
        ArrayList<RequestHandler> othersList = new ArrayList<RequestHandler>();
        for (RequestHandler requestHandler : this.rh) {
            HandlerType type = requestHandler.getType();
            if (type.equals((Object)HandlerType.FILE)) {
                fileList.add(requestHandler);
                continue;
            }
            if (type.equals((Object)HandlerType.ERROR)) {
                errorList.add(requestHandler);
                continue;
            }
            othersList.add(requestHandler);
        }
        this.rh = new ArrayList<RequestHandler>();
        this.rh.addAll(fileList);
        this.rh.addAll(errorList);
        this.rh.addAll(othersList);
    }

    public final void handleRequest(Request r) throws IOException {
        for (RequestHandler requestHandler : this.rh) {
            try {
                requestHandler.handleRequest(r);
                return;
            }
            catch (IOException exc) {
            }
        }
    }

    public final HandlerType getType() {
        return HandlerType.DELEGATING;
    }
}

