/***
 * OW2 FraSCAti Examples: Counter
 * Copyright (C) 2009 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s): Nicolas Dolet
 */

package org.ow2.frascati.examples.counter.api;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.FormParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.osoa.sca.annotations.Service;

/**
 * A simple counter service.
 * 
 * @author Philippe Merle
 */
@Service
public interface CounterService {
  /**
   * Return the counter value.
   * 
   * @return the counter value.
   */
  @GET
  @Path("/")
  @Produces("text/plain")
  int getValue();

  /**
   * Increment the counter value.
   */
  @POST
  @Path("/incr")
  void increment(@FormParam("v") int v);

  /**
   * Decrement the counter value.
   */
  @POST
  @Path("/decr")
  void decrement(@FormParam("v") int v);

  /**
   * Reset the counter value.
   * 
   * NOTE: Apache CXF 2.2.2 does not allow to name this method 'reset'. Because
   * the proxy generated by the Apache CXF JAXRS client frontend inherits from
   * the Client interface which already declares a 'reset' method.
   */
  @POST
  @Path("/reset")
  void resetIt();
}
