/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.counter.explorer;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.objectweb.util.explorer.api.TreeView;
import org.ow2.frascati.examples.counter.api.CounterService;
import org.ow2.frascati.explorer.gui.AbstractSelectionPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterServicePanel
extends AbstractSelectionPanel<CounterService> {
    private JLabel valueLabel;

    public CounterServicePanel() {
        this.setLayout(new GridLayout(4, 1));
        JPanel panel1 = new JPanel();
        this.add(panel1);
        panel1.add(new JLabel("Current counter value: "));
        this.valueLabel = new JLabel();
        panel1.add(this.valueLabel);
        JPanel panel2 = new JPanel();
        this.add(panel2);
        JButton incrementButton = new JButton("Increment");
        panel2.add(incrementButton);
        panel2.add(new JLabel("with: "));
        final JTextField incrementField = new JTextField(5);
        panel2.add(incrementField);
        incrementButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ((CounterService)CounterServicePanel.this.getSelection()).increment(Integer.parseInt(incrementField.getText()));
                    CounterServicePanel.this.refreshValueLabel();
                }
                catch (NumberFormatException nfe) {
                    throw new Error(nfe);
                }
            }
        });
        JPanel panel3 = new JPanel();
        this.add(panel3);
        JButton decrementButton = new JButton("Decrement");
        panel3.add(decrementButton);
        panel3.add(new JLabel("with: "));
        final JTextField decrementField = new JTextField(5);
        panel3.add(decrementField);
        decrementButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ((CounterService)CounterServicePanel.this.getSelection()).decrement(Integer.parseInt(decrementField.getText()));
                    CounterServicePanel.this.refreshValueLabel();
                }
                catch (NumberFormatException nfe) {
                    throw new Error(nfe);
                }
            }
        });
        JPanel panel4 = new JPanel();
        this.add(panel4);
        JButton resetButton = new JButton("Reset the counter value");
        panel4.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((CounterService)CounterServicePanel.this.getSelection()).resetIt();
                CounterServicePanel.this.refreshValueLabel();
            }
        });
    }

    protected void refreshValueLabel() {
        this.valueLabel.setText(String.valueOf(((CounterService)this.getSelection()).getValue()));
    }

    public void selected(TreeView treeView) {
        super.selected(treeView);
        this.refreshValueLabel();
    }
}

