/***
 * OW2 FraSCAti Examples: ISBN test
 * Copyright (C) 2009 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Christophe Demarey 
 *
 * Contributor(s):
 * 
 */

package org.ow2.frascati.examples.isbntest.explorer;

import org.ow2.frascati.examples.isbntest.api.Verifier;
import org.ow2.frascati.explorer.action.AbstractAlwaysEnabledMenuItem;

/**
 * Is the FraSCAti Explorer plugin to execute {@link Verify#verify(String,String)}.
 *
 * @author Christophe Demarey
 */
public class VerifyMenuItem extends AbstractAlwaysEnabledMenuItem<Verifier> {

  /**
   * @see org.ow2.frascati.explorer.action.AbstractAlwaysEnabledMenuItem#execute()
   */
  @Override
  protected void execute(Verifier verifier) {
    System.out.println(verifier.verify(Verifier.ISBN_13_TYPE,"978-0321180865"));
  }
}
