/**
 * OW2 FraSCAti: Sales BPEL
 * Copyright (C) 2010 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 *
 */

package org.ow2.frascati.examples.sales;

/**
 * @author Philippe Merle - INRIA
 */
public final class Helper
{
  private Helper() {}

  public static String toString(SalesRequest salesRequest)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("SalesRequest(article=");
    sb.append(toString(salesRequest.getArticle()));
    sb.append(")");
    return sb.toString();
  }

  public static String toString(SalesItem salesItem)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("SalesItem(refId=");
    sb.append(salesItem.getRefId());
    sb.append(", name=");
    sb.append(salesItem.getName());
    sb.append(", quantity=");
    sb.append(salesItem.getQuantity());
    sb.append(")");
    return sb.toString();
  }

  public static String toString(SalesResponse salesResponse)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("SalesResponse(result=");
    sb.append(salesResponse.getResult());
    sb.append("), salesItem=StockItem(refId=");
    sb.append(toString(salesResponse.getArticle()));
    sb.append(")");
    return sb.toString();
  }

  public static String toString(StockRequest stockRequest)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("StockRequest(article=StockItem(refId=");
	StockItem article = stockRequest.getArticle();
    sb.append(article.getRefId());
    sb.append(", quantity=");
    sb.append(article.getQuantity());
    sb.append("))");
    return sb.toString();
  }

  public static String toString(StockResponse stockResponse)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("StockResponse(refId=");
    sb.append(stockResponse.getRefId());
    sb.append(", result=");
    sb.append(stockResponse.isResult());
    sb.append("))");
    return sb.toString();
  }

}
