/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.sales;

import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;
import org.ow2.frascati.examples.sales.Sales;
import org.ow2.frascati.examples.sales.SalesAsyncCallback;
import org.ow2.frascati.examples.sales.SalesItem;
import org.ow2.frascati.examples.sales.SalesRequest;
import org.ow2.frascati.examples.sales.SalesResponse;
import org.ow2.frascati.examples.sales.Stock;

@Scope(value="COMPOSITE")
@Service(interfaces={Runnable.class, SalesAsyncCallback.class})
public class ClientImpl
implements Runnable,
SalesAsyncCallback {
    private Logger log = Logger.getLogger(Stock.class.getCanonicalName());
    @Property(name="refId")
    private int refId;
    @Property(name="name")
    private String name;
    @Property(name="quantity")
    private int quantity;
    @Reference(name="sales")
    private Sales sales;
    private Semaphore semaphore = new Semaphore(0);

    public final void run() {
        this.log.info("CLIENT: run() called.");
        SalesRequest salesRequest = new SalesRequest();
        this.log.info("CLIENT: Preparing the SalesRequest...");
        SalesItem salesItem = new SalesItem();
        salesItem.setRefId(this.refId);
        salesItem.setName(this.name);
        salesItem.setQuantity(this.quantity);
        salesRequest.setArticle(salesItem);
        this.log.info("CLIENT: Calling sales.initiate(" + salesRequest.toString() + ")...");
        this.sales.initiate(salesRequest);
        this.log.info("CLIENT: Waiting the SalesResponse...");
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException exc) {
            this.log.info("CLIENT: run() interrupted.");
            return;
        }
        this.log.info("CLIENT: run() finished.");
    }

    public final void onResultSales(SalesResponse salesResponse) {
        this.log.info("CLIENT: onResultSales(" + salesResponse.toString() + ") called.");
        this.semaphore.release();
        this.log.info("CLIENT: onResultSales(" + salesResponse.toString() + ") finished.");
    }
}

