/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.sales;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;
import org.ow2.frascati.examples.sales.Sales;
import org.ow2.frascati.examples.sales.Stock;
import org.ow2.frascati.examples.sales.StockItem;
import org.ow2.frascati.examples.sales.StockRequest;
import org.ow2.frascati.examples.sales.StockResponse;

@Scope(value="COMPOSITE")
@Service(value=Stock.class)
public class StockImpl
implements Stock {
    private Logger log = Logger.getLogger(Stock.class.getCanonicalName());
    @Reference(name="process")
    private Sales process;
    @Property(name="numberOfWorkIterations")
    private int numberOfWorkIterations = 5;
    @Property(name="iterationDuration")
    private int iterationDuration = 100;
    private Map<Integer, Integer> stock = new HashMap<Integer, Integer>(){
        {
            for (int i = 0; i < 100; ++i) {
                this.put(i, 100);
            }
        }
    };

    public final void initiate(StockRequest stockRequest) {
        this.log.info("STOCK: initiate(" + stockRequest.toString() + ") called.");
        StockItem articleIn = stockRequest.getArticle();
        for (int i = 1; i <= this.numberOfWorkIterations; ++i) {
            this.log.info("STOCK: initiate(" + stockRequest.toString() + ") works (" + i + "/" + this.numberOfWorkIterations + ")...");
            try {
                Thread.sleep(this.iterationDuration);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        StockResponse stockResponse = new StockResponse();
        stockResponse.setRefId(articleIn.getRefId());
        Integer availability = this.stock.get(articleIn.getRefId());
        if (availability != null && availability >= articleIn.getQuantity()) {
            stockResponse.setResult(true);
            this.stock.put(articleIn.getRefId(), availability - articleIn.getQuantity());
        } else {
            stockResponse.setResult(false);
        }
        this.log.info("STOCK: Calling process.onResultStock(" + stockResponse.toString() + ")...");
        this.process.onResultStock(stockResponse);
        this.log.info("STOCK: initiate(" + stockRequest.toString() + ") finished.");
    }
}

