/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.twitterweather.lib;

import net.webservicex.GlobalWeatherSoap;
import org.osoa.sca.annotations.Reference;
import org.ow2.frascati.examples.twitterweather.api.Decoder;
import org.ow2.frascati.examples.twitterweather.api.Twitter;
import org.ow2.frascati.examples.twitterweather.api.TwitterWeather;
import org.ow2.frascati.examples.twitterweather.xml.Location;
import org.ow2.frascati.examples.twitterweather.xml.Locations;
import org.ow2.frascati.examples.twitterweather.xml.User;

public class Orchestration
implements TwitterWeather {
    @Reference
    private Twitter twitter;
    @Reference
    protected Decoder decoder;
    @Reference
    protected GlobalWeatherSoap weather;

    public String getWeatherForUser(String userId) {
        User user = this.twitter.getUser(userId);
        if (user.location.equals("")) {
            System.err.println("The user " + userId + " has not filled in his location");
            return "N/A";
        }
        String[] location = user.location.split("[\\s]*,[\\s]*", 2);
        String cityName = location[0];
        String countryName = location[1];
        System.out.println("User '" + userId + "' is living in " + cityName + " (" + countryName + ")");
        String cities = this.weather.getCitiesByCountry(countryName);
        Locations l = this.decoder.decode(cities);
        String result = "";
        if (l != null) {
            boolean done = false;
            for (Location loc : l.location) {
                if (!loc.city.value.toLowerCase().contains(cityName.toLowerCase())) continue;
                result = result + "Current weather in " + loc.city.value + ":\n";
                result = result + this.weather.getWeather(loc.city.value, countryName) + "\n";
                done = true;
            }
            if (!done) {
                System.err.println("Unable to find '" + cityName + "' in available cities of the weather service");
            }
        }
        return result;
    }
}

