/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.examples.twitterweather.lib;

import java.util.Locale;
import net.webservicex.GlobalWeatherSoap;
import org.osoa.sca.annotations.Reference;
import org.ow2.frascati.examples.twitterweather.api.Decoder;
import org.ow2.frascati.examples.twitterweather.api.Twitter;
import org.ow2.frascati.examples.twitterweather.api.TwitterWeather;
import org.ow2.frascati.examples.twitterweather.xml.Location;
import org.ow2.frascati.examples.twitterweather.xml.Locations;
import org.ow2.frascati.examples.twitterweather.xml.User;

public class Orchestration
implements TwitterWeather {
    @Reference
    private Twitter twitter;
    @Reference
    private Decoder decoder;
    @Reference
    private GlobalWeatherSoap weather;

    public final String getWeatherForUser(String userId) {
        User user = this.twitter.getUser(userId);
        if (user.getLocation().equals("")) {
            System.err.println("The user " + userId + " has not filled in his location");
            return "N/A";
        }
        String[] location = user.getLocation().split("[\\s]*,[\\s]*", 2);
        String cityName = location[0];
        String countryName = location[1];
        System.out.println("User '" + userId + "' is living in " + cityName + " (" + countryName + ")");
        String cities = this.weather.getCitiesByCountry(countryName);
        Locations l = this.decoder.decode(cities);
        StringBuffer result = new StringBuffer();
        if (l != null) {
            boolean done = false;
            for (Location loc : l.location) {
                if (!loc.city.value.toLowerCase(Locale.US).contains(cityName.toLowerCase(Locale.US))) continue;
                result.append("Current weather in ").append(loc.city.value).append(":\n");
                result.append(this.weather.getWeather(loc.city.value, countryName)).append('\n');
                done = true;
            }
            if (!done) {
                System.err.println("Unable to find '" + cityName + "' in available cities of the weather service");
            }
        }
        return result.toString();
    }
}

