/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.factory.runtime.domain;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.bf.BindingFactory;
import org.objectweb.fractal.bf.BindingFactoryException;
import org.objectweb.fractal.fraclet.annotations.Attribute;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.ow2.frascati.factory.core.dispatcher.Manager;
import org.ow2.frascati.factory.core.domain.DomainException;
import org.ow2.frascati.factory.core.domain.api.CompositeDomain;
import org.ow2.frascati.factory.core.instance.runtime.RuntimeFactory;
import org.ow2.frascati.factory.core.instance.util.ScaCompositeHelper;
import org.ow2.frascati.factory.generate.runtime.RuntimeGenerate;
import org.ow2.frascati.factory.runtime.domain.DomainManagerAttributes;
import org.ow2.frascati.factory.runtime.domain.api.Domain;
import org.ow2.frascati.factory.runtime.domain.api.DomainConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DomainManager
implements BindingController,
DomainManagerAttributes,
Domain,
DomainConfig {
    protected static Logger log = Logger.getLogger(DomainManager.class.getCanonicalName());
    @Controller
    private org.objectweb.fractal.api.Component domainManager;
    @Requires(name="domain-management")
    private CompositeDomain domain;
    @Requires(name="load")
    private Manager load;
    @Requires(name="juliac")
    private RuntimeGenerate generate;
    @Requires(name="runtime")
    private RuntimeFactory runtime;
    @Requires(name="binding")
    private BindingFactory binding;
    @Attribute(value="frascati")
    public String rmiServiceName;
    @Attribute(value="localhost")
    public String host;
    @Attribute(value="1099")
    public String port;

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        if (this.binding != null) {
            list.add("binding");
        }
        if (this.runtime != null) {
            list.add("runtime");
        }
        if (this.generate != null) {
            list.add("juliac");
        }
        if (this.load != null) {
            list.add("load");
        }
        if (this.domain != null) {
            list.add("domain-management");
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("binding")) {
            return this.binding;
        }
        if (string.equals("runtime")) {
            return this.runtime;
        }
        if (string.equals("juliac")) {
            return this.generate;
        }
        if (string.equals("load")) {
            return this.load;
        }
        if (string.equals("domain-management")) {
            return this.domain;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.domainManager = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("binding")) {
            this.binding = (BindingFactory)object;
            return;
        }
        if (string.equals("runtime")) {
            this.runtime = (RuntimeFactory)object;
            return;
        }
        if (string.equals("juliac")) {
            this.generate = (RuntimeGenerate)object;
            return;
        }
        if (string.equals("load")) {
            this.load = (Manager)object;
            return;
        }
        if (string.equals("domain-management")) {
            this.domain = (CompositeDomain)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getRmiServiceName() {
        return this.rmiServiceName;
    }

    @Override
    public void setHost(String string) {
        this.host = string;
    }

    @Override
    public void setPort(String string) {
        this.port = string;
    }

    @Override
    public void setRmiServiceName(String string) {
        this.rmiServiceName = string;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("binding")) {
            this.binding = null;
            return;
        }
        if (string.equals("runtime")) {
            this.runtime = null;
            return;
        }
        if (string.equals("juliac")) {
            this.generate = null;
            return;
        }
        if (string.equals("load")) {
            this.load = null;
            return;
        }
        if (string.equals("domain-management")) {
            this.domain = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void ExportDomain() throws DomainException {
        try {
            log.info("Starting new FraSCAti Domain on " + InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            log.info("Starting new FraSCAti Domain");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("plugin.id", "rmi");
        hashMap.put("classloader", this.runtime.getClassLoader());
        hashMap.put("serviceName", this.rmiServiceName);
        hashMap.put("port", this.port);
        hashMap.put("hostAddress", this.host);
        try {
            log.info("Export FraSCAti domain using RMI with parameters host=" + this.host + " port=" + this.port + " service=" + this.rmiServiceName);
            this.binding.export(this.domainManager, "domain-frascati", hashMap);
        }
        catch (BindingFactoryException bindingFactoryException) {
            throw new DomainException("Fails to export Domain for remote management", (Exception)((Object)bindingFactoryException));
        }
    }

    @Override
    public void addLibraries(URL ... uRLArray) {
        String[] stringArray = new String[uRLArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = uRLArray[n].getPath();
            ++n;
        }
        this.load.loadJars(uRLArray);
        this.generate.addJavaLib(stringArray);
    }

    @Override
    public org.objectweb.fractal.api.Component getComposite(String string) throws DomainException {
        return this.getComposite(string, null);
    }

    @Override
    public org.objectweb.fractal.api.Component getComposite(String string, URL[] uRLArray) throws DomainException {
        org.objectweb.fractal.api.Component component = this.domain.get(string);
        if (component == null) {
            if (uRLArray != null) {
                this.addLibraries(uRLArray);
            }
            component = (org.objectweb.fractal.api.Component)this.load.loadComposite(string);
            ScaCompositeHelper.start((org.objectweb.fractal.api.Component)component);
            this.domain.add(component);
        }
        return component;
    }

    @Override
    public org.objectweb.fractal.api.Component[] getComposites() {
        return this.domain.getAll();
    }

    @Override
    public String[] getCompositesNames() {
        return this.domain.list();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.runtime.getClassLoader();
    }

    @Override
    public void setClassLoader(URLClassLoader uRLClassLoader) {
        this.runtime.setClassLoader((ClassLoader)uRLClassLoader);
    }

    @Override
    public void setOutput(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Output must be a directory");
        }
        file.createNewFile();
        this.generate.setOutputDir(file);
    }

    @Override
    public void removeComposite(String string) throws DomainException {
        this.domain.remove(string);
    }
}

