/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.factory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.ow2.frascati.factory.AbstractFactory;
import org.ow2.frascati.factory.AssemblyFactory;
import org.ow2.frascati.factory.Factory;
import org.ow2.frascati.factory.GenerateFactory;

public class GenerateFactoryMojo
extends AbstractMojo {
    private String composite;
    private String service;
    private String method;
    private String[] srcs;
    private String[] libs;
    private String factory;
    private boolean debug;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = this.project.getBasedir();
        File fs = new File(baseDir.getAbsolutePath() + File.separator + "src/main/java");
        if (fs.exists()) {
            this.srcs = this.addToArray(this.srcs, "src/main/java");
        }
        this.libs = this.addToArray(this.libs, "src/main/resources");
        ArrayList<URL> list = new ArrayList<URL>();
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            try {
                list.add(artifact.getFile().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("Could add dependency " + artifact.getId()));
            }
        }
        for (String lib : this.libs) {
            File f = null;
            try {
                f = new File(baseDir.getAbsolutePath() + File.separator + lib);
                if (!f.exists()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                try {
                    f = new File(lib);
                    if (!f.exists()) {
                        throw new Exception();
                    }
                    System.out.println(lib);
                }
                catch (Exception e2) {
                    this.getLog().error((CharSequence)("Could not add library path : " + lib));
                }
            }
            try {
                list.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Could not add library path : " + lib));
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.factory.compareToIgnoreCase("GenerateFactory") == 0) {
            GenerateFactory generateFactory = new GenerateFactory(this.srcs);
            generateFactory.setOutput(baseDir.getAbsolutePath());
            generateFactory.setDebug(this.debug);
            generateFactory.getComposite(this.composite, urls);
        } else if (this.factory.compareToIgnoreCase("RuntimeFactory") == 0) {
            Factory f = new Factory();
            AbstractFactory.run((AbstractFactory)f, (String)this.composite, (String)this.service, (String)this.method, (URL[])urls);
        } else if (this.factory.compareToIgnoreCase("AssemblyFactory") == 0) {
            AssemblyFactory f = new AssemblyFactory();
            AbstractFactory.run((AbstractFactory)f, (String)this.composite, (String)this.service, (String)this.method, (URL[])urls);
        } else {
            throw new MojoExecutionException("'" + this.factory + "' is not a kind of factory! " + "Please use one of 'GenerateFactory', 'RuntimeFactory', 'AssemblyFactory'.");
        }
    }

    private String[] addToArray(String[] array, String s) {
        if (array == null | array.length == 0) {
            return new String[]{s};
        }
        String[] ans = new String[array.length + 1];
        System.arraycopy(array, 0, ans, 0, array.length);
        ans[array.length] = s;
        return ans;
    }
}

