/**
 * OW2 FraSCAti: SCA Binding JMS
 * Copyright (C) 2010 ScalAgent Distributed Technologies, INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 * 
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.util.Map;

import org.objectweb.fractal.bf.connectors.common.GenericConnector;
import org.objectweb.fractal.bf.connectors.common.GenericBindHints;
import org.objectweb.fractal.bf.connectors.common.GenericExportHints;

/**
 * A JMS-Connector can export and bind Fractal interfaces via JMS.
 * 
 */
public class JmsConnector extends GenericConnector {

	/**
	 * @see org.objectweb.fractal.bf.BindingFactoryPlugin#getPluginIdentifier()
	 */
	public final String getPluginIdentifier() {
		return "jms";
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.common.AbstractConnector#getSkeletonAdl()
	 */
	@Override
	protected final String getSkeletonAdl() {
		return "org.objectweb.fractal.bf.connectors.jms.JmsSkeleton";
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.common.AbstractConnector#initSkeletonAdlContext(EH,
	 *      Map)
	 */
	@Override
	protected final void initSkeletonAdlContext(GenericExportHints exportHints,
			Map<String, Object> context) {
		String uri = (String)exportHints.get(JmsConnectorConstants.URI, JmsConnectorConstants.NO_URI);
		context.put(JmsConnectorConstants.URI, uri);
		String jndiURL = (String)exportHints.get(JmsConnectorConstants.JMS_JNDI_URL, JmsConnectorConstants.NO_JNDI_URL);
		context.put(JmsConnectorConstants.JMS_JNDI_URL, jndiURL);
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.common.AbstractConnector#getStubAdl()
	 */
	@Override
	protected final String getStubAdl() {
		return "org.objectweb.fractal.bf.connectors.jms.JmsStub";
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.common.AbstractConnector#initStubAdlContext(BH,
	 *      Map)
	 */
	@Override
	protected final void initStubAdlContext(GenericBindHints bindHints,
			Map<String, Object> context) {
		generateStubContentClass(JmsStubContent.class, context);
		String uri = (String)bindHints.get(JmsConnectorConstants.URI, JmsConnectorConstants.NO_URI);
		context.put(JmsConnectorConstants.URI, uri);
		String jndiURL = (String)bindHints.get(JmsConnectorConstants.JMS_JNDI_URL, JmsConnectorConstants.NO_JNDI_URL);
		context.put(JmsConnectorConstants.JMS_JNDI_URL, jndiURL);
	}

}
