/**
 * OW2 FraSCAti: SCA Binding JMS
 * Copyright (C) 2010 ScalAgent Distributed Technologies, INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 * 
 */
package org.objectweb.fractal.bf.connectors.jms;

import org.objectweb.fractal.bf.connectors.common.uri.UriSkeletonContent;

/**
 * The content implementation of JMS skeleton components.
 */
public class JmsSkeletonContent
     extends UriSkeletonContent
  implements JmsSkeletonContentAttributes
{
	/**
	 * The jndiURL to configure the binding.
	 */
	private String jndiURL;

	/**
	 * @see org.objectweb.fractal.bf.connectors.jms.JmsStubContentAttributes#getJndiURL()
	 */
	public final String getJndiURL() {
		return this.jndiURL;
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.jms.JmsStubContentAttributes#setJndiURL(java.lang.String)
	 */
	public final void setJndiURL(String jndiURL) {
		this.jndiURL = jndiURL;
	}

	/**
	 * @see org.objectweb.fractal.api.control.LifeCycleController#startFc()
	 */
	@Override
	public final void startFc() {
		JmsBroker.registerSkeleton(getUri(), getServant(), getServiceClass());
		super.startFc();
	}

	/**
	 * @see org.objectweb.fractal.api.control.LifeCycleController#stopFc()
	 */
	@Override
	public final void stopFc() {
		JmsBroker.unregisterSkeleton(getUri(), getServant());
		super.stopFc();
	}

}
