/**
 * OW2 FraSCAti: SCA Binding JMS
 * Copyright (C) 2010 ScalAgent Distributed Technologies, INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 * 
 */
package org.objectweb.fractal.bf.connectors.jms;

import org.objectweb.fractal.bf.connectors.common.uri.UriStubContent;

/**
 * A super class for JMS stubs. Concrete classes are generated on the fly.
 */
public abstract class JmsStubContent
              extends UriStubContent
           implements JmsStubContentAttributes {

	/**
	 * The jndiURL to configure the binding.
	 */
	private String jndiURL;

	/**
	 * @see org.objectweb.fractal.bf.connectors.jms.JmsStubContentAttributes#getJndiURL()
	 */
	public final String getJndiURL() {
		return this.jndiURL;
	}

	/**
	 * @see org.objectweb.fractal.bf.connectors.jms.JmsStubContentAttributes#setJndiURL(java.lang.String)
	 */
	public final void setJndiURL(String jndiURL) {
		this.jndiURL = jndiURL;
	}

	/**
	 * Build a JMS client.
	 * 
	 * @return the object instantiated.
	 */
	protected final Object resolveReference()
	{
		return JmsBroker.createStub(getUri(), getServiceClass());
	}

}
