/**
 * OW2 FraSCAti SCA Binding JMS
 * Copyright (C) 2010 ScalAgent Distributed Technologies, INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Guillaume Surrel
 *
 * Contributor(s): Philippe Merle
 *
 */
package org.ow2.frascati.binding.jms;

import java.util.Map;

import org.eclipse.stp.sca.JMSBinding;
import org.eclipse.stp.sca.ScaPackage;

import org.objectweb.fractal.bf.connectors.jms.JmsConnectorConstants;

import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.binding.factory.AbstractBindingFactoryProcessor;

/**
 * Bind SCA components using JMS Binding.
 */
public class FrascatiBindingJmsProcessor
     extends AbstractBindingFactoryProcessor<JMSBinding> {

  // --------------------------------------------------------------------------
  // Internal methods.
  // --------------------------------------------------------------------------

  /**
   * @see org.ow2.frascati.assembly.factory.processor.AbstractProcessor#toStringBuffer(EObjectType, StringBuffer)
   */
  @Override
  protected final void toStringBuffer(JMSBinding jmsBinding, StringBuffer sb) {
    sb.append("sca:binding.jms");
    append(sb, "correlationScheme", jmsBinding.getCorrelationScheme());
    append(sb, "initialContextFactory", jmsBinding.getInitialContextFactory());
    append(sb, "jndiURL", jmsBinding.getJndiURL());
    super.toStringBuffer(jmsBinding, sb);
  }

  /**
   * @see org.ow2.frascati.assembly.factory.api.Processor#check(ElementType, ProcessingContext)
   */
  @Override
  protected final void doCheck(JMSBinding jmsBinding, ProcessingContext processingContext)
      throws ProcessorException
  {
    // TODO: Here various checking could be specifically done on the JMSBinding instance.
    // TODO: Check if getUri() is well-formed.

	// Default checking done on any SCA binding.
	super.doCheck(jmsBinding, processingContext);
  }

  /**
   * @see AbstractBindingFactoryProcessor#getBindingFactoryPluginId()
   */
  @Override
  protected final String getBindingFactoryPluginId() {
    return "jms";
  }

  /**
   * @see AbstractBindingFactoryProcessor#initializeBindingHints(EObjectType, Map)
   */
  @Override
  protected final void initializeBindingHints(JMSBinding jmsBinding, Map<String, Object> hints) {
    // set protocol specific parameters
    hints.put(JmsConnectorConstants.URI, jmsBinding.getUri());
    hints.put(JmsConnectorConstants.JMS_JNDI_URL, jmsBinding.getJndiURL());
  }

  // --------------------------------------------------------------------------
  // Public methods.
  // --------------------------------------------------------------------------

  /**
   * @see org.ow2.frascati.assembly.factory.api.Processor#getProcessorID()
   */
  public final String getProcessorID() {
    return getID(ScaPackage.Literals.JMS_BINDING);
  }

}
