/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.bf.connectors.jms.JmsListener;
import org.objectweb.fractal.bf.connectors.jms.JmsQueue;
import org.objectweb.fractal.bf.connectors.jms.JmsStubInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmsBroker {
    private static Map<String, JmsQueue> uri2queue = new HashMap<String, JmsQueue>();
    private static Map<Object, JmsListener> servant2listener = new HashMap<Object, JmsListener>();

    private JmsBroker() {
    }

    public static synchronized void registerSkeleton(String uri, Object servant, Class<?> interfaze) {
        JmsQueue queue = JmsBroker.getJmsQueue(uri);
        JmsListener listener = new JmsListener(servant, interfaze, queue);
        servant2listener.put(servant, listener);
    }

    public static synchronized void unregisterSkeleton(String uri, Object servant) {
        JmsListener listener = servant2listener.remove(servant);
        listener.queue.listeners.remove(listener);
    }

    public static Object createStub(String uri, Class<?> clazz) {
        JmsStubInvocationHandler ih = new JmsStubInvocationHandler();
        ih.queue = JmsBroker.getJmsQueue(uri);
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)((Object)ih));
    }

    private static synchronized JmsQueue getJmsQueue(String uri) {
        JmsQueue queue = uri2queue.get(uri);
        if (queue == null) {
            queue = new JmsQueue();
            uri2queue.put(uri, queue);
        }
        return queue;
    }
}

