/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.util.Map;
import org.objectweb.fractal.bf.connectors.common.GenericBindHints;
import org.objectweb.fractal.bf.connectors.common.GenericConnector;
import org.objectweb.fractal.bf.connectors.common.GenericExportHints;
import org.objectweb.fractal.bf.connectors.jms.JmsStubContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnector
extends GenericConnector {
    public final String getPluginIdentifier() {
        return "jms";
    }

    protected final String getSkeletonAdl() {
        return "org.objectweb.fractal.bf.connectors.jms.JmsSkeleton";
    }

    protected final void initSkeletonAdlContext(GenericExportHints exportHints, Map<String, Object> context) {
        String uri = (String)exportHints.get("uri", "no_uri");
        context.put("uri", uri);
        String correlationScheme = (String)exportHints.get("correlationScheme", "messageID");
        context.put("correlationScheme", correlationScheme);
        String jndiURL = (String)exportHints.get("jndiURL", "no_jndiURL");
        context.put("jndiURL", jndiURL);
        String jndiInitialContextFactory = (String)exportHints.get("jndiInitialContextFactory", "no_ContextFactory");
        context.put("jndiInitialContextFactory", jndiInitialContextFactory);
        String jndiConnFactName = (String)exportHints.get("jndiConnectionFactoryName", "cf");
        context.put("jndiConnectionFactoryName", jndiConnFactName);
        String jndiDestName = (String)exportHints.get("jndiDestinationName", "no_jndiURL");
        context.put("jndiDestinationName", jndiDestName);
        String destType = (String)exportHints.get("destinationType", "no_type");
        context.put("destinationType", destType);
        String createDest = (String)exportHints.get("createDestinationMode", "ifNotExist");
        context.put("createDestinationMode", createDest);
        String jmsPriority = (String)exportHints.get("priority", "4");
        context.put("priority", jmsPriority);
        String timeToLive = (String)exportHints.get("timeToLive", "0");
        context.put("timeToLive", timeToLive);
        String selector = (String)exportHints.get("selector", "");
        context.put("selector", selector);
        String deliveryMode = (String)exportHints.get("deliveryMode", "persistent");
        if (deliveryMode.equalsIgnoreCase("persistent")) {
            context.put("persistent", "true");
        } else if (deliveryMode.equalsIgnoreCase("nonpersistent")) {
            context.put("persistent", "false");
        } else {
            this.log.warning("Unrecognized delivery mode, set to persistent");
            context.put("persistent", "true");
        }
        String jndiResponseDestName = (String)exportHints.get("jndiResponseDestinationName", "scaResponseDestination");
        context.put("jndiResponseDestinationName", jndiResponseDestName);
    }

    protected final String getStubAdl() {
        return "org.objectweb.fractal.bf.connectors.jms.JmsStub";
    }

    protected final void initStubAdlContext(GenericBindHints bindHints, Map<String, Object> context) {
        this.generateStubContentClass(JmsStubContent.class, context);
        String uri = (String)bindHints.get("uri", "no_uri");
        context.put("uri", uri);
        String correlationScheme = (String)bindHints.get("correlationScheme", "messageID");
        context.put("correlationScheme", correlationScheme);
        String jndiURL = (String)bindHints.get("jndiURL", "no_jndiURL");
        context.put("jndiURL", jndiURL);
        String jndiInitialContextFactory = (String)bindHints.get("jndiInitialContextFactory", "no_ContextFactory");
        context.put("jndiInitialContextFactory", jndiInitialContextFactory);
        String jndiConnFactName = (String)bindHints.get("jndiConnectionFactoryName", "cf");
        context.put("jndiConnectionFactoryName", jndiConnFactName);
        String jndiDestName = (String)bindHints.get("jndiDestinationName", "no_jndiURL");
        context.put("jndiDestinationName", jndiDestName);
        String createDest = (String)bindHints.get("createDestinationMode", "ifNotExist");
        context.put("createDestinationMode", createDest);
        String destType = (String)bindHints.get("destinationType", "no_type");
        context.put("destinationType", destType);
        String jmsPriority = (String)bindHints.get("priority", "4");
        context.put("priority", jmsPriority);
        String timeToLive = (String)bindHints.get("timeToLive", "0");
        context.put("timeToLive", timeToLive);
        String selector = (String)bindHints.get("selector", "");
        context.put("selector", selector);
        String deliveryMode = (String)bindHints.get("deliveryMode", "persistent");
        if (deliveryMode.equalsIgnoreCase("persistent")) {
            context.put("persistent", "true");
        } else if (deliveryMode.equalsIgnoreCase("nonpersistent")) {
            context.put("persistent", "false");
        } else {
            this.log.warning("Unrecognized delivery mode, set to persistent");
            context.put("persistent", "true");
        }
        String jndiResponseDestName = (String)bindHints.get("jndiResponseDestinationName", "scaResponseDestination");
        context.put("jndiResponseDestinationName", jndiResponseDestName);
    }
}

