/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.net.ConnectException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.objectweb.fractal.bf.connectors.jms.JmsAttributes;
import org.objectweb.fractal.bf.connectors.jms.JoramServer;

public class JmsModule {
    protected Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    private JmsAttributes jmsAttributes;
    private Connection jmsCnx;
    private Session session;
    private Destination destination;
    private Session responseSession;
    private Destination responseDestination;

    public JmsModule(JmsAttributes jmsAttributes) {
        this.jmsAttributes = jmsAttributes;
    }

    public Connection getJmsCnx() {
        return this.jmsCnx;
    }

    public Session getSession() {
        return this.session;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Session getResponseSession() {
        return this.responseSession;
    }

    public Destination getResponseDestination() {
        return this.responseDestination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws JMSException, NamingException {
        ConnectionFactory cf;
        InitialContext ictx;
        block15: {
            this.log.info("******************************");
            this.log.info("correlationScheme: " + this.jmsAttributes.getCorrelationScheme());
            this.log.info("JndiURL: " + this.jmsAttributes.getJndiURL());
            this.log.info("ConnFactName: " + this.jmsAttributes.getJndiConnectionFactoryName());
            this.log.info("InitialContextFactory: " + this.jmsAttributes.getJndiInitialContextFactory());
            this.log.info("DestinationName: " + this.jmsAttributes.getJndiDestinationName());
            this.log.info("CreateDestinationMode: " + this.jmsAttributes.getCreateDestinationMode());
            this.log.info("DestinationType: " + this.jmsAttributes.getDestinationType());
            this.log.info("priority: " + this.jmsAttributes.getPriority());
            this.log.info("ttl: " + this.jmsAttributes.getTimeToLive());
            this.log.info("selector: " + this.jmsAttributes.getSelector());
            this.log.info("persistent: " + this.jmsAttributes.getPersistent());
            this.log.info("******************************");
            Hashtable<String, String> environment = new Hashtable<String, String>();
            if (!this.jmsAttributes.getJndiInitialContextFactory().equals("no_ContextFactory")) {
                environment.put("java.naming.factory.initial", this.jmsAttributes.getJndiInitialContextFactory());
            }
            if (!this.jmsAttributes.getJndiURL().equals("no_jndiURL")) {
                environment.put("java.naming.provider.url", this.jmsAttributes.getJndiURL());
            }
            ictx = new InitialContext(environment);
            try {
                cf = (ConnectionFactory)ictx.lookup(this.jmsAttributes.getJndiConnectionFactoryName());
            }
            catch (NamingException exc) {
                if (!(exc.getCause() instanceof ConnectException)) throw exc;
                this.log.log(Level.WARNING, "ConnectException while trying to reach JNDI server -> launching a collocated JORAM server instead.");
                JoramServer.start();
                cf = (ConnectionFactory)ictx.lookup(this.jmsAttributes.getJndiConnectionFactoryName());
            }
            try {
                this.destination = (Destination)ictx.lookup(this.jmsAttributes.getJndiDestinationName());
            }
            catch (NameNotFoundException nnfe) {
                if (!this.jmsAttributes.getCreateDestinationMode().equals("never")) break block15;
                throw new IllegalStateException("Destination " + this.jmsAttributes.getJndiDestinationName() + " not found in JNDI.");
            }
        }
        this.jmsCnx = cf.createConnection();
        this.session = this.jmsCnx.createSession(false, 1);
        this.responseSession = this.jmsCnx.createSession(false, 1);
        this.jmsCnx.start();
        if (this.destination == null) {
            if (this.jmsAttributes.getDestinationType().equals("queue")) {
                this.destination = this.session.createQueue(this.jmsAttributes.getJndiDestinationName());
                ictx.bind(this.jmsAttributes.getJndiDestinationName(), (Object)this.destination);
            } else {
                if (!this.jmsAttributes.getDestinationType().equals("topic")) throw new IllegalStateException("Unknown destination type: " + this.jmsAttributes.getDestinationType());
                this.destination = this.session.createTopic(this.jmsAttributes.getJndiDestinationName());
                ictx.bind(this.jmsAttributes.getJndiDestinationName(), (Object)this.destination);
            }
        } else {
            if (this.jmsAttributes.getCreateDestinationMode().equals("always")) {
                throw new IllegalStateException("Destination " + this.jmsAttributes.getJndiDestinationName() + " already exists in JNDI.");
            }
            if (this.jmsAttributes.getDestinationType().equals("queue") && !(this.destination instanceof Queue)) {
                throw new IllegalStateException("Object found in JNDI " + this.jmsAttributes.getJndiDestinationName() + " does not match declared type 'queue'.");
            }
            if (this.jmsAttributes.getDestinationType().equals("topic") && !(this.destination instanceof Topic)) {
                throw new IllegalStateException("Object found in JNDI " + this.jmsAttributes.getJndiDestinationName() + " does not match declared type 'topic'.");
            }
        }
        try {
            this.responseDestination = (Destination)ictx.lookup(this.jmsAttributes.getJndiResponseDestinationName());
        }
        catch (NameNotFoundException nnfe) {
            this.responseDestination = this.responseSession.createQueue(this.jmsAttributes.getJndiResponseDestinationName());
            ictx.bind(this.jmsAttributes.getJndiResponseDestinationName(), (Object)this.responseDestination);
        }
        ictx.close();
    }

    public void close() throws JMSException {
        if (this.jmsCnx != null) {
            this.jmsCnx.close();
        }
    }
}

