/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import org.objectweb.fractal.bf.connectors.common.uri.UriSkeletonContent;
import org.objectweb.fractal.bf.connectors.jms.JmsModule;
import org.objectweb.fractal.bf.connectors.jms.JmsSkeletonContentAttributes;
import org.ow2.frascati.wsdl.WsdlDelegate;
import org.ow2.frascati.wsdl.WsdlDelegateFactory;

public class JmsSkeletonContent
extends UriSkeletonContent
implements JmsSkeletonContentAttributes,
MessageListener {
    private String correlationScheme;
    private String jndiURL;
    private String jndiDestinationName;
    private String createDestinationMode;
    private String destinationType;
    private String jndiInitialContextFactory;
    private String jndiConnFactName;
    private boolean persistent;
    private long timeToLive;
    private int priority;
    private String selector;
    private WsdlDelegate delegate;
    private String jndiResponseDestinationName;
    private JmsModule jmsModule;

    public String getCorrelationScheme() {
        return this.correlationScheme;
    }

    public void setCorrelationScheme(String correlationScheme) {
        this.correlationScheme = correlationScheme;
    }

    public String getJndiDestinationName() {
        return this.jndiDestinationName;
    }

    public void setJndiDestinationName(String jndiDestinationName) {
        this.jndiDestinationName = jndiDestinationName;
    }

    public String getCreateDestinationMode() {
        return this.createDestinationMode;
    }

    public void setCreateDestinationMode(String createDestinationMode) {
        this.createDestinationMode = createDestinationMode;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnFactName;
    }

    public void setJndiConnectionFactoryName(String jndiConnFactName) {
        this.jndiConnFactName = jndiConnFactName;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getJndiURL() {
        return this.jndiURL;
    }

    public void setJndiURL(String jndiURL) {
        this.jndiURL = jndiURL;
    }

    public String getJndiResponseDestinationName() {
        return this.jndiResponseDestinationName;
    }

    public void setJndiResponseDestinationName(String jndiResponseDestinationName) {
        this.jndiResponseDestinationName = jndiResponseDestinationName;
    }

    public final void startFc() {
        this.delegate = WsdlDelegateFactory.newWsdlDelegate((Object)this.getServant(), (Class)this.getServiceClass());
        try {
            this.jmsModule = new JmsModule(this);
            this.jmsModule.start();
            MessageConsumer consumer = this.jmsModule.getSession().createConsumer(this.jmsModule.getDestination(), this.getSelector());
            consumer.setMessageListener((MessageListener)this);
        }
        catch (Exception exc) {
            throw new IllegalStateException("Error starting JMS skeleton -> " + exc.getMessage(), exc);
        }
        super.startFc();
    }

    public final void stopFc() {
        try {
            this.jmsModule.close();
        }
        catch (JMSException exc) {
            this.log.severe("JmsSkeletonContent.stopFc() -> " + exc.getMessage());
        }
        super.stopFc();
    }

    public void onMessage(Message msg) {
        this.log.fine("onMessage: " + msg);
        try {
            Object servant = this.getServant();
            String operation = msg.getStringProperty("scaOperationName");
            Method[] methods = servant.getClass().getDeclaredMethods();
            if (methods.length == 1) {
                this.log.fine("Servant unique operation called.");
                this.invokeMethod(methods[0], msg);
                return;
            }
            if (operation != null) {
                this.log.fine("Looking for '" + operation + "' operation.");
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!m.getName().equals(operation)) continue;
                    this.invokeMethod(methods[i], msg);
                    return;
                }
                this.log.severe("JmsSkeletonContent.onMessage() -> Operation not found");
            } else {
                this.log.warning("Not yet implemented");
            }
        }
        catch (Throwable exc) {
            this.log.log(Level.SEVERE, "JmsSkeletonContent.onMessage() -> " + exc.getMessage(), exc);
        }
    }

    private void invokeMethod(Method method, Message msg) throws Exception {
        this.log.fine("invokeMethod " + method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object response = null;
        if (parameterTypes.length == 0) {
            response = method.invoke(this.getServant(), (Object[])null);
        } else if (parameterTypes.length == 1 && Message.class.isAssignableFrom(parameterTypes[0])) {
            this.log.fine("Pass the JMSMessage as is.");
            response = method.invoke(this.getServant(), msg);
        } else if (msg instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)msg;
            byte[] data = new byte[(int)bytesMsg.getBodyLength()];
            bytesMsg.readBytes(data);
            Method m = this.delegate.getMethod(method.getName());
            response = this.delegate.invoke(m, new String(data));
        } else if (msg instanceof TextMessage) {
            TextMessage txtMsg = (TextMessage)msg;
            Method m = this.delegate.getMethod(method.getName());
            response = this.delegate.invoke(m, txtMsg.getText());
        } else {
            this.log.severe("Received message is invalid.");
        }
        if (method.getReturnType().equals(Void.TYPE) && method.getExceptionTypes().length == 0) {
            this.log.fine("One-way message exchange");
        } else {
            this.log.fine("Request/response message exchange");
            TextMessage responseMsg = this.jmsModule.getResponseSession().createTextMessage();
            if (this.getCorrelationScheme().equals("correlationID")) {
                responseMsg.setJMSCorrelationID(msg.getJMSCorrelationID());
            } else if (this.getCorrelationScheme().equals("messageID")) {
                responseMsg.setJMSCorrelationID(msg.getJMSMessageID());
            }
            if (responseMsg != null) {
                responseMsg.setText(response.toString());
            }
            Destination responseDest = msg.getJMSReplyTo();
            this.log.fine("ReplyTo field: " + responseDest);
            if (responseDest == null) {
                responseDest = this.jmsModule.getResponseDestination();
            }
            if (responseDest == null) {
                throw new Exception("No response destination found.");
            }
            MessageProducer responseProducer = this.jmsModule.getResponseSession().createProducer(responseDest);
            responseProducer.send((Message)responseMsg);
            responseProducer.close();
        }
        this.log.fine("invokeMethod done");
    }
}

