/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bf.connectors.jms;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.objectweb.fractal.bf.connectors.jms.JmsModule;
import org.ow2.frascati.jaxb.JAXB;
import org.ow2.frascati.wsdl.AbstractWsdlInvocationHandler;

public class JmsStubInvocationHandler
extends AbstractWsdlInvocationHandler {
    private boolean persistent;
    private long timeToLive;
    private int priority;
    private MessageProducer producer;
    private JmsModule jmsModule;

    public JmsStubInvocationHandler(JmsModule jmsModule, boolean persistent, int priority, long ttl, MessageProducer producer) {
        this.jmsModule = jmsModule;
        this.persistent = persistent;
        this.priority = priority;
        this.timeToLive = ttl;
        this.producer = producer;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        this.log.fine("Send message");
        TextMessage msg = this.jmsModule.getSession().createTextMessage();
        msg.setStringProperty("scaOperationName", m.getName());
        msg.setJMSReplyTo(this.jmsModule.getResponseDestination());
        if (args != null) {
            msg.setText(this.marshallInvocation(m, args));
        }
        this.producer.send((Message)msg, this.persistent ? 2 : 1, this.priority, this.timeToLive);
        if (m.getReturnType().equals(Void.TYPE) && m.getExceptionTypes().length == 0) {
            return null;
        }
        String selector = "JMSCorrelationID = '" + msg.getJMSMessageID() + "'";
        Session respSession = this.jmsModule.getJmsCnx().createSession(false, 1);
        MessageConsumer responseConsumer = respSession.createConsumer(this.jmsModule.getResponseDestination(), selector);
        Message responseMsg = responseConsumer.receive();
        responseConsumer.close();
        respSession.close();
        this.log.fine("Response received. " + ((TextMessage)responseMsg).getText());
        Object response = JAXB.unmarshall((QName)JmsStubInvocationHandler.getQNameOfFirstArgument(m), (String)((TextMessage)responseMsg).getText(), null);
        return response;
    }

    protected static String getTargetNamespace(Method method) {
        WebService ws = method.getDeclaringClass().getAnnotation(WebService.class);
        return ws.targetNamespace();
    }

    protected static QName toQName(WebParam wp, Method method) {
        String targetNamespace = wp.targetNamespace();
        if (targetNamespace == null || targetNamespace.equals("")) {
            targetNamespace = JmsStubInvocationHandler.getTargetNamespace(method);
        }
        return new QName(targetNamespace, wp.name());
    }

    protected static QName getQNameOfFirstArgument(Method method) throws Exception {
        Annotation[][] pa = method.getParameterAnnotations();
        WebParam wp = (WebParam)pa[0][0];
        return JmsStubInvocationHandler.toQName(wp, method);
    }
}

