/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.binding.jms;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stp.sca.Binding;
import org.eclipse.stp.sca.CorrelationSchemeType;
import org.eclipse.stp.sca.CreateResource;
import org.eclipse.stp.sca.JMSBinding;
import org.eclipse.stp.sca.Response;
import org.eclipse.stp.sca.ScaPackage;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.binding.factory.AbstractBindingFactoryProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrascatiBindingJmsProcessor
extends AbstractBindingFactoryProcessor<JMSBinding> {
    private static Pattern JMS_URI_PATTERN;

    protected final void toStringBuilder(JMSBinding jmsBinding, StringBuilder sb) {
        sb.append("sca:binding.jms");
        FrascatiBindingJmsProcessor.append((StringBuilder)sb, (String)"correlationScheme", (Object)jmsBinding.getCorrelationScheme());
        FrascatiBindingJmsProcessor.append((StringBuilder)sb, (String)"initialContextFactory", (String)jmsBinding.getInitialContextFactory());
        FrascatiBindingJmsProcessor.append((StringBuilder)sb, (String)"jndiURL", (String)jmsBinding.getJndiURL());
        super.toStringBuilder((Binding)jmsBinding, sb);
    }

    protected final void doCheck(JMSBinding jmsBinding, ProcessingContext processingContext) throws ProcessorException {
        if (jmsBinding.getUri() != null && !jmsBinding.getUri().equals("")) {
            Matcher matcher = JMS_URI_PATTERN.matcher(jmsBinding.getUri());
            if (!matcher.matches()) {
                throw new ProcessorException((Object)jmsBinding, "JMS URI is not well formed.");
            }
            String jmsvariant = matcher.group(1);
            try {
                jmsvariant = URLDecoder.decode(jmsvariant, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.severe("UTF-8 format not supported: can't decode JMS URI.");
            }
            if (!jmsvariant.equals("jndi")) {
                throw new ProcessorException((Object)jmsBinding, "Only jms:jndi: variant is supported.");
            }
            if (jmsBinding.getDestination() != null) {
                throw new ProcessorException((Object)jmsBinding, "Binding can't have both a JMS URI and a destination element.");
            }
        }
        super.doCheck((Binding)jmsBinding, processingContext);
    }

    protected final String getBindingFactoryPluginId() {
        return "jms";
    }

    protected final void initializeBindingHints(JMSBinding jmsBinding, Map<String, Object> hints) {
        Response response;
        hints.put("uri", jmsBinding.getUri());
        hints.put("jndiURL", jmsBinding.getJndiURL());
        hints.put("jndiInitialContextFactory", jmsBinding.getInitialContextFactory());
        if (jmsBinding.getCorrelationScheme() != null) {
            if (jmsBinding.getCorrelationScheme().equals((Object)CorrelationSchemeType.REQUEST_CORREL_ID_TO_CORREL_ID)) {
                hints.put("correlationScheme", "correlationID");
            } else if (jmsBinding.getCorrelationScheme().equals((Object)CorrelationSchemeType.REQUEST_MSG_ID_TO_CORREL_ID)) {
                hints.put("correlationScheme", "messageID");
            }
        }
        if (jmsBinding.getHeaders() != null) {
            hints.put("deliveryMode", jmsBinding.getHeaders().getJMSDeliveryMode());
            hints.put("timeToLive", String.valueOf(jmsBinding.getHeaders().getJMSTimeToLive()));
            hints.put("priority", String.valueOf(jmsBinding.getHeaders().getJMSPriority()));
        }
        if (jmsBinding.getDestination() != null) {
            hints.put("jndiDestinationName", jmsBinding.getDestination().getName());
            if (jmsBinding.getDestination().getCreate() == null) {
                hints.put("createDestinationMode", "ifNotExist");
            } else if (jmsBinding.getDestination().getCreate().equals((Object)CreateResource.ALWAYS)) {
                hints.put("createDestinationMode", "always");
            } else if (jmsBinding.getDestination().getCreate().equals((Object)CreateResource.NEVER)) {
                hints.put("createDestinationMode", "never");
            } else if (jmsBinding.getDestination().getCreate().equals((Object)CreateResource.IFNOTEXIST)) {
                hints.put("createDestinationMode", "ifNotExist");
            }
            if (jmsBinding.getDestination().getType() != null) {
                hints.put("destinationType", jmsBinding.getDestination().getType().getName());
            } else {
                hints.put("destinationType", "queue");
            }
        }
        if (jmsBinding.getResponse() != null && (response = jmsBinding.getResponse()).getDestination() != null) {
            hints.put("jndiResponseDestinationName", response.getDestination().getName());
        }
        if (jmsBinding.getUri() != null && !jmsBinding.getUri().equals("")) {
            Matcher matcher = JMS_URI_PATTERN.matcher(jmsBinding.getUri());
            matcher.matches();
            String jmsdest = matcher.group(2);
            try {
                jmsdest = URLDecoder.decode(jmsdest, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.severe("UTF-8 format not supported: can't decode JMS URI.");
            }
            hints.put("jndiDestinationName", jmsdest);
            hints.put("createDestinationMode", "never");
            String optionGroup = matcher.group(3);
            if (optionGroup != null) {
                String[] options = optionGroup.split("&");
                for (int i = 0; i < options.length; ++i) {
                    String option = options[i];
                    String[] paramAndValue = option.split("=");
                    String param = paramAndValue[0];
                    try {
                        URLDecoder.decode(param, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.severe("UTF-8 format not supported: can't decode JMS URI.");
                    }
                    String value = "";
                    if (paramAndValue.length > 1) {
                        value = paramAndValue[1];
                        try {
                            value = URLDecoder.decode(value, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            this.log.severe("UTF-8 format not supported: can't decode JMS URI.");
                        }
                    }
                    if (param.equals("jndiURL")) {
                        hints.put("jndiURL", value);
                        continue;
                    }
                    if (param.equals("jndiInitialContextFactory")) {
                        hints.put("jndiInitialContextFactory", value);
                        continue;
                    }
                    if (param.equals("jndiConnectionFactoryName")) {
                        hints.put("jndiConnectionFactoryName", value);
                        continue;
                    }
                    if (param.equals("deliveryMode")) {
                        hints.put("deliveryMode", value);
                        continue;
                    }
                    if (param.equals("timeToLive")) {
                        hints.put("timeToLive", value);
                        continue;
                    }
                    if (param.equals("priority")) {
                        hints.put("priority", value);
                        continue;
                    }
                    if (!param.equals("selector")) continue;
                    hints.put("selector", value);
                }
            }
        }
        if (jmsBinding.getResponse() != null && jmsBinding.getResponse().getDestination() != null) {
            hints.put("jndiResponseDestinationName", jmsBinding.getResponse().getDestination().getName());
        }
    }

    public final String getProcessorID() {
        return FrascatiBindingJmsProcessor.getID((EClass)ScaPackage.Literals.JMS_BINDING);
    }

    static {
        String hexdig = "[a-fA-F0-9]";
        String pctencoded = "(?:%" + hexdig + hexdig + ")";
        String unreserved = "[a-zA-Z0-9-._~]";
        String subdelims = "[!$&'()*+,;=]";
        String segment = "(?:" + unreserved + '|' + subdelims + '|' + pctencoded + '|' + "[@:])*";
        String segmentnz = "(?:" + unreserved + '|' + subdelims + '|' + pctencoded + '|' + "[@:])+";
        String segmentnznc = "(?:" + unreserved + '|' + subdelims + '|' + pctencoded + '|' + "[@])+";
        String pathrootless = segmentnz + "(?:/" + segment + ")*";
        String paramname = "(?:" + unreserved + '|' + pctencoded + ")+";
        String paramvalue = "(?:" + unreserved + '|' + pctencoded + ")*";
        String param = paramname + "=" + paramvalue;
        String prefix = "jms:";
        String delimeter = ":";
        String jmsuri = prefix + '(' + segmentnznc + ')' + delimeter + '(' + pathrootless + ')' + "(?:\\?(" + param + "(?:&" + param + ")*))?";
        JMS_URI_PATTERN = Pattern.compile(jmsuri);
    }
}

