/**
 * OW2 FraSCAti SCA Binding Java RMI
 * Copyright (C) 2008-2010 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Damien Fournier
 *
 * Contributor(s): Nicolas Dolet, Philippe Merle
 *
 */

package org.ow2.frascati.binding.rmi;

import java.net.URL;
import java.rmi.RMISecurityManager;
import java.util.Map;

import org.eclipse.stp.sca.domainmodel.frascati.FrascatiPackage;
import org.eclipse.stp.sca.domainmodel.frascati.RMIBinding;

import org.objectweb.fractal.bf.connectors.rmi.RmiConnectorConstants;

import org.osoa.sca.annotations.Init;

import org.ow2.frascati.binding.factory.AbstractBindingFactoryProcessor;

/**
 * Bind components using Java RMI Binding.
 * 
 * @author <a href="mailto:damien.fournier@inria.fr">Damien Fournier</a>
 * @version 1.3
 */
public class FrascatiBindingJavaRmiProcessor
     extends AbstractBindingFactoryProcessor<RMIBinding>
{
  // --------------------------------------------------------------------------
  // Internal methods.
  // --------------------------------------------------------------------------

  /**
   * @see org.ow2.frascati.assembly.factory.processor.AbstractProcessor#toStringBuffer(EObjectType, StringBuffer)
   */
  @Override
  protected final void toStringBuffer(RMIBinding rmiBinding, StringBuffer sb) {
    sb.append("frascati:binding.rmi");
    append(sb, "host", rmiBinding.getHost());
    append(sb, "port", rmiBinding.getPort());
    append(sb, "serviceName", rmiBinding.getServiceName());
    super.toStringBuffer(rmiBinding, sb);
  }

  /**
   * @see AbstractBindingFactoryProcessor#getBindingFactoryPluginId()
   */
  @Override
  protected final String getBindingFactoryPluginId() {
    return "rmi";
  }

  /**
   * @see AbstractBindingFactoryProcessor#initializeBindingHints(EObjectType, Map)
   */
  @Override
  protected final void initializeBindingHints(RMIBinding rmiBinding, Map<String, Object> hints) {
    // set protocol specific parameters
    hints.put(RmiConnectorConstants.SERVICE_NAME, rmiBinding.getServiceName());
    hints.put(RmiConnectorConstants.JAVA_RMI_REGISTRY_PORT, rmiBinding.getPort());
    hints.put(RmiConnectorConstants.JAVA_RMI_REGISTRY_HOST_ADDRESS, rmiBinding.getHost());
  }

  // --------------------------------------------------------------------------
  // Public methods.
  // --------------------------------------------------------------------------

  /**
   * Set Java policy when starting RMI plugin.
   */
  @SuppressWarnings("unused")
  @Init
  public final void init() {
	  // TODO FraSCAti Java RMI policy property.
    URL policyURL = this.getClass().getClassLoader().getResource("frascati.policy");
    if (policyURL == null ) {
      log.warning("Java policy file not found for OW2 FraSCAti : using default Java policy!");
    } else {
      System.setProperty("java.security.policy", policyURL.toString());
      if (System.getSecurityManager() == null) {
        System.setSecurityManager(new RMISecurityManager());
      }
    }
  }

  /**
   * @see org.ow2.frascati.assembly.factory.api.Processor#getProcessorID()
   */
  public final String getProcessorID() {
    return getID(FrascatiPackage.Literals.RMI_BINDING);
  }

}
