/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.component.factory.juliac.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.component.factory.api.FactoryException;
import org.ow2.frascati.component.factory.api.MembraneGeneration;
import org.ow2.frascati.component.factory.api.MembraneProvider;
import org.ow2.frascati.component.factory.juliac.api.JuliacCompilerProvider;
import org.ow2.frascati.util.AbstractLoggeable;
import org.ow2.frascati.util.FrascatiClassLoader;
import org.ow2.frascati.util.FrascatiException;

@Scope(value="COMPOSITE")
public class JuliacComponent
extends AbstractLoggeable
implements MembraneGeneration {
    public static final String FRASCATI_OUTPUT_DIRECTORY_PROPERTY = "org.ow2.frascati.output.directory";
    @Property(name="FRASCATI-GENERATED")
    private String frascatiGeneratedDirectory = "FRASCATI_GENERATED";
    @Property(name="MAVEN-TARGET-DIRECTORY")
    private String mavenTargetDirectory = "target";
    @Property(name="GEN-DIRECTORY")
    private String genDirectory = "/generated-frascati-sources";
    @Property(name="CLASS-DIRECTORY")
    private String classDirectory = "/generated-frascati-classes";
    @Reference(name="generators")
    private List<MembraneProvider> juliacGeneratorClassProviders;
    @Reference(name="compiler-provider", required=false)
    private JuliacCompilerProvider juliacCompilerProvider;
    private File outputDir;
    private Juliac jc;
    private JuliacConfig jcfg;
    private List<String> javaSourcesToCompile = new ArrayList<String>();
    private List<MembraneDescription> membranesToGenerate = new ArrayList<MembraneDescription>();

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = JuliacComponent.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    @Init
    public final void initialization() throws FrascatiException {
        try {
            this.jc = new Juliac();
        }
        catch (Exception e) {
            this.severe(new FrascatiException("Problem when initializing Juliac", (Throwable)e));
            return;
        }
        this.jcfg = new JuliacConfig(this.jc);
        this.jc.setJuliacConfig(this.jcfg);
        this.jcfg.setSourceLevel(JDKLevel.JDK1_5);
        this.jcfg.setTargetLevel(JDKLevel.JDK1_5);
        if (this.juliacCompilerProvider != null) {
            this.jcfg.setCompiler(this.juliacCompilerProvider.getJuliacCompiler());
        }
        StringBuffer juliacOptLevel = new StringBuffer();
        boolean isNotFirst = false;
        for (MembraneProvider jgc : this.juliacGeneratorClassProviders) {
            if (isNotFirst) {
                juliacOptLevel.append(':');
            }
            juliacOptLevel.append(jgc.getMembraneClass().getCanonicalName());
            isNotFirst = true;
        }
        this.jcfg.setOptLevel(juliacOptLevel.toString());
        this.jcfg.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            this.jcfg.loadOptLevels();
        }
        catch (Exception e) {
            this.severe(new FrascatiException("Problem when loading Juliac option levels", (Throwable)e));
            return;
        }
    }

    public final void setOutputDir(File outputDir) throws IOException {
        if (!outputDir.equals(this.outputDir)) {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (!outputDir.isDirectory()) {
                throw new IOException(outputDir + " must be a directory");
            }
            this.log.info("Default Juliac output directory: " + outputDir.toString());
            this.outputDir = outputDir;
            this.jcfg.setBaseDir(outputDir);
            File f = new File(outputDir, this.genDirectory);
            if (f.exists()) {
                this.log.info("Deleting directory " + f);
                JuliacComponent.deleteDir(f);
            }
            this.jcfg.setGenDirName(String.valueOf(outputDir.getCanonicalPath()) + this.genDirectory);
            this.jcfg.setClassDirName(String.valueOf(outputDir.getCanonicalPath()) + this.classDirectory);
        }
    }

    public final String getOutputDirectory() {
        return this.jcfg.getBaseDir().getAbsolutePath();
    }

    public final void open(FrascatiClassLoader frascatiClassLoader) throws FactoryException {
        this.jcfg.setClassLoader((ClassLoader)frascatiClassLoader);
        if (this.outputDir == null) {
            try {
                File f;
                String defaultOutputDir = System.getenv().get(this.frascatiGeneratedDirectory);
                if (defaultOutputDir != null) {
                    f = new File(defaultOutputDir);
                } else {
                    defaultOutputDir = System.getProperty(FRASCATI_OUTPUT_DIRECTORY_PROPERTY);
                    if (defaultOutputDir != null) {
                        f = new File(defaultOutputDir);
                    } else {
                        f = new File(String.valueOf(new File(".").getAbsolutePath()) + File.separator + this.mavenTargetDirectory).getAbsoluteFile();
                        if (!f.exists()) {
                            f = File.createTempFile("frascati", ".tmp");
                            f.delete();
                            f.mkdir();
                            f.deleteOnExit();
                        }
                    }
                }
                this.setOutputDir(f);
            }
            catch (IOException ioe) {
                this.severe((FrascatiException)new FactoryException("Problem when creating a FraSCAti temp directory", (Throwable)ioe));
                return;
            }
        }
        try {
            frascatiClassLoader.addUrl(new File(String.valueOf(this.outputDir.getCanonicalPath()) + this.classDirectory).toURI().toURL());
        }
        catch (Exception e) {
            this.severe((FrascatiException)new FactoryException((Throwable)e));
        }
    }

    public final void generate(ComponentType componentType, String membraneDesc, String contentClass) throws FactoryException {
        MembraneDescription md = new MembraneDescription();
        md.componentType = componentType;
        md.membraneDesc = membraneDesc;
        md.contentDesc = contentClass;
        this.membranesToGenerate.add(md);
    }

    public final void addJavaSource(String javaSourcePath) {
        this.javaSourcesToCompile.add(javaSourcePath);
    }

    public final void close() throws FactoryException {
        for (String src : this.javaSourcesToCompile) {
            this.log.info("* compile Java source: " + src);
            try {
                this.jcfg.addSrc(src);
            }
            catch (IOException ioe) {
                this.severe((FrascatiException)new FactoryException("Cannot add Java sources", (Throwable)ioe));
                return;
            }
        }
        if (this.javaSourcesToCompile.size() > 0) {
            try {
                this.jc.compile();
            }
            catch (Exception e) {
                this.warning((FrascatiException)new FactoryException("Cannot compile with Juliac", (Throwable)e));
                return;
            }
        }
        this.javaSourcesToCompile.clear();
        for (MembraneDescription md : this.membranesToGenerate) {
            try {
                this.jc.getFCSourceCodeGenerator((Object)md.membraneDesc).generate((Type)md.componentType, (Object)md.membraneDesc, md.contentDesc);
            }
            catch (Exception e) {
                this.severe((FrascatiException)new FactoryException("Cannot generate component code with Juliac", (Throwable)e));
                return;
            }
        }
        this.membranesToGenerate.clear();
        try {
            this.jc.compile();
        }
        catch (Exception e) {
            this.severe((FrascatiException)new FactoryException("Cannot compile with Juliac", (Throwable)e));
            return;
        }
        try {
            this.jc.close();
        }
        catch (Exception e) {
            this.severe((FrascatiException)new FactoryException("Cannot close Juliac", (Throwable)e));
            return;
        }
    }

    private static class MembraneDescription {
        public ComponentType componentType;
        public String membraneDesc;
        public Object contentDesc;

        private MembraneDescription() {
        }
    }
}

