/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.fractal.adl.util.ContentControllerHelper;
import org.objectweb.fractal.adl.util.NoSuchComponentException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.bf.BindingFactory;
import org.objectweb.fractal.bf.BindingFactoryException;
import org.objectweb.fractal.fscript.model.AbstractAxis;
import org.objectweb.fractal.fscript.model.Model;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.types.Type;
import org.objectweb.fractal.fscript.types.UnionType;
import org.objectweb.fractal.util.BindingControllerHelper;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.fscript.model.ScaBindingNode;
import org.ow2.frascati.fscript.model.ScaReferenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaBindingAxis
extends AbstractAxis {
    private static Logger logger = Logger.getLogger("org.ow2.frascati.fscript.model.ScaBindingAxis");

    public ScaBindingAxis(FraSCAtiModel model) {
        super((Model)model, "scabinding", (Type)new UnionType(new Type[]{model.getNodeKind("scaservice"), model.getNodeKind("scareference")}), (Type)model.getNodeKind("scabinding"));
    }

    public final boolean isPrimitive() {
        return true;
    }

    public final boolean isModifiable() {
        return true;
    }

    public final Set<Node> selectFrom(Node source) {
        HashSet<Node> result = new HashSet<Node>();
        InterfaceNode itfNode = null;
        Interface itf = null;
        try {
            itfNode = (InterfaceNode)source;
            itf = itfNode.getInterface();
        }
        catch (ClassCastException e) {
            logger.info("The scabinding axis is only available for Interface nodes!");
            return Collections.emptySet();
        }
        if (itfNode.isClient()) {
            ScaBindingNode bindingNode = null;
            Interface serverItf = null;
            Component itfOwner = itf.getFcItfOwner();
            try {
                BindingController bc = Fractal.getBindingController((Component)itfOwner);
                serverItf = (Interface)bc.lookupFc(itf.getFcItfName());
                try {
                    String boundInterfaceOwnerName = Fractal.getNameController((Component)serverItf.getFcItfOwner()).getFcName();
                    if (boundInterfaceOwnerName.contains("-rmi-stub")) {
                        try {
                            Component stub = ContentControllerHelper.getSubComponentByName((Component)serverItf.getFcItfOwner(), (String)"rmi-stub-primitive");
                            bindingNode = new ScaBindingNode((FraSCAtiModel)this.model, stub);
                            result.add((Node)bindingNode);
                            return result;
                        }
                        catch (NoSuchComponentException e) {
                            logger.severe("Cannot found rmi-stub-primitive component in the " + boundInterfaceOwnerName + "composite!");
                        }
                    }
                }
                catch (NoSuchInterfaceException e1) {
                    e1.printStackTrace();
                    return Collections.emptySet();
                }
            }
            catch (NoSuchInterfaceException e) {
                logger.fine(e.toString());
                return Collections.emptySet();
            }
            bindingNode = new ScaBindingNode((FraSCAtiModel)this.model, serverItf.getFcItfOwner());
            result.add((Node)bindingNode);
        } else {
            Set clientItfs = BindingControllerHelper.getFcClientItfsBoundTo((Interface)itf);
            for (Interface clientItf : clientItfs) {
                Component clientItfOwner = clientItf.getFcItfOwner();
                try {
                    clientItfOwner.getFcInterface("sca-component-controller");
                }
                catch (NoSuchInterfaceException e) {
                    ScaBindingNode bindingNode = new ScaBindingNode((FraSCAtiModel)this.model, clientItfOwner);
                    result.add((Node)bindingNode);
                }
            }
            Node rmiBinding = this.getRmiBinding(itf);
            if (rmiBinding != null) {
                result.add(rmiBinding);
            }
        }
        return result;
    }

    private Node getRmiBinding(Interface itf) {
        Component itfOwner = itf.getFcItfOwner();
        try {
            Component[] parents;
            for (Component parent : parents = Fractal.getSuperController((Component)itfOwner).getFcSuperComponents()) {
                Component[] children;
                for (Component child : children = Fractal.getContentController((Component)parent).getFcSubComponents()) {
                    String childName = Fractal.getNameController((Component)child).getFcName();
                    if (!childName.contains("-rmi-skeleton")) continue;
                    try {
                        Component skeleton = ContentControllerHelper.getSubComponentByName((Component)child, (String)"org.objectweb.fractal.bf.connectors.rmi.RmiSkeletonContent");
                        return new ScaBindingNode((FraSCAtiModel)this.model, skeleton);
                    }
                    catch (NoSuchComponentException e) {
                        logger.severe("Cannot found org.objectweb.fractal.bf.connectors.rmi.RmiSkeletonContent component in the " + childName + "composite!");
                    }
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            logger.fine(e.toString());
            return null;
        }
        return null;
    }

    public final void disconnect(Node source, Node dest) {
        Interface itf = ((InterfaceNode)source).getInterface();
        Component bindingComponent = ((ScaBindingNode)dest).getComponent();
        boolean isScaReference = source instanceof ScaReferenceNode;
        String itfName = itf.getFcItfName();
        Component owner = itf.getFcItfOwner();
        FraSCAtiModel model = (FraSCAtiModel)this.model;
        BindingFactory bf = null;
        try {
            bf = (BindingFactory)model.lookupFc("binding-factory");
        }
        catch (NoSuchInterfaceException nsie) {
            logger.log(Level.SEVERE, "Cannot retrieve the Binding Factory!", nsie);
            return;
        }
        try {
            if (isScaReference) {
                bf.unbind(owner, itfName, bindingComponent);
            } else {
                bf.unexport(owner, bindingComponent, new HashMap());
            }
        }
        catch (BindingFactoryException bfe) {
            logger.log(Level.SEVERE, "Cannot unbind/unexport this service/reference!", bfe);
        }
    }
}

