/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fscript.model.AbstractAxis;
import org.objectweb.fractal.fscript.model.Model;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.types.Type;
import org.objectweb.fractal.fscript.types.UnionType;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.fscript.model.ScaComponentNode;
import org.ow2.frascati.fscript.model.ScaIntentNode;
import org.ow2.frascati.tinfi.TinfiDomain;
import org.ow2.frascati.tinfi.control.intent.IntentHandler;
import org.ow2.frascati.tinfi.control.intent.SCABasicIntentController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaIntentAxis
extends AbstractAxis {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());

    public ScaIntentAxis(FraSCAtiModel model) {
        super((Model)model, "scaintent", (Type)new UnionType(new Type[]{model.getNodeKind("scaservice"), model.getNodeKind("scareference")}), (Type)model.getNodeKind("scacomponent"));
    }

    public final boolean isPrimitive() {
        return true;
    }

    public final boolean isModifiable() {
        return true;
    }

    public final Set<Node> selectFrom(Node source) {
        Component comp = null;
        Interface itf = null;
        SCABasicIntentController ic = null;
        try {
            comp = ((ComponentNode)source).getComponent();
        }
        catch (ClassCastException e1) {
            try {
                itf = ((InterfaceNode)source).getInterface();
                comp = itf.getFcItfOwner();
            }
            catch (ClassCastException e2) {
                throw new IllegalArgumentException("Invalid source node kind " + source.getKind());
            }
        }
        HashSet<Node> result = new HashSet<Node>();
        try {
            ic = (SCABasicIntentController)comp.getFcInterface("sca-intent-controller");
        }
        catch (NoSuchInterfaceException e) {
            return Collections.emptySet();
        }
        try {
            if (itf == null) {
                for (Object anItf : comp.getFcInterfaces()) {
                    result.addAll(this.getIntentNodes(ic, (Interface)anItf));
                }
            } else {
                result.addAll(this.getIntentNodes(ic, itf));
            }
        }
        catch (NoSuchInterfaceException e) {
            this.log.warning("One interface cannot be retrieved on " + comp + "!");
            e.printStackTrace();
        }
        return result;
    }

    private List<ScaIntentNode> getIntentNodes(SCABasicIntentController ic, Interface itf) throws NoSuchInterfaceException {
        ArrayList<ScaIntentNode> nodes = new ArrayList<ScaIntentNode>();
        String itfName = itf.getFcItfName();
        if (!itfName.endsWith("-controller") && !itfName.equals("component")) {
            List intents = ic.listFcIntentHandler(itf.getFcItfName());
            for (IntentHandler intent : intents) {
                Component impl = ((Interface)intent).getFcItfOwner();
                String name = Fractal.getNameController((Component)impl).getFcName();
                nodes.add(new ScaIntentNode((FraSCAtiModel)this.model, ic, name, impl, itf));
            }
        }
        return nodes;
    }

    public final void connect(Node source, Node dest) {
        Interface itf = ((InterfaceNode)source).getInterface();
        Component intent = ((ScaComponentNode)dest).getComponent();
        Component itfOwner = null;
        SCABasicIntentController ic = null;
        String intentName = null;
        try {
            itfOwner = itf.getFcItfOwner();
        }
        catch (ClassCastException cce) {
            this.log.log(Level.WARNING, "An intent can only be applied on components, services and references!");
            return;
        }
        try {
            ic = (SCABasicIntentController)itfOwner.getFcInterface("sca-intent-controller");
        }
        catch (NoSuchInterfaceException nsie) {
            this.log.log(Level.SEVERE, "Cannot access to intent controller", nsie);
            return;
        }
        if (intent != null) {
            String itfName = null;
            try {
                intentName = Fractal.getNameController((Component)intent).getFcName();
            }
            catch (NoSuchInterfaceException nsie) {
                this.log.log(Level.SEVERE, "Cannot find the Name Controller!", nsie);
            }
            try {
                Fractal.getLifeCycleController((Component)itfOwner).stopFc();
                IntentHandler h = (IntentHandler)TinfiDomain.getService((Component)intent, IntentHandler.class, (String)"intent");
                if (itf != null) {
                    itfName = itf.getFcItfName();
                    ic.addFcIntentHandler(h, itfName);
                } else {
                    ic.addFcIntentHandler(h);
                }
                Fractal.getLifeCycleController((Component)itfOwner).startFc();
            }
            catch (Exception e1) {
                String errorMsg = itf != null ? "interface " + itfName : "component";
                this.log.log(Level.SEVERE, "Intent '" + intentName + "' cannot be added to " + errorMsg, e1);
            }
        }
    }

    public final void disconnect(Node source, Node dest) {
        Interface itf = ((InterfaceNode)source).getInterface();
        Component intent = ((ScaComponentNode)dest).getComponent();
        Component itfOwner = itf.getFcItfOwner();
        SCABasicIntentController ic = null;
        try {
            ic = (SCABasicIntentController)itf.getFcItfOwner().getFcInterface("sca-intent-controller");
        }
        catch (NoSuchInterfaceException nsie) {
            this.log.log(Level.SEVERE, "Cannot access to intent controller", nsie);
        }
        try {
            Fractal.getLifeCycleController((Component)itfOwner).stopFc();
            IntentHandler h = (IntentHandler)TinfiDomain.getService((Component)intent, IntentHandler.class, (String)"intent");
            ic.removeFcIntentHandler(h, itf.getFcItfName());
            Fractal.getLifeCycleController((Component)itfOwner).startFc();
        }
        catch (NoSuchInterfaceException nsie) {
            this.log.log(Level.SEVERE, "Cannot retrieve the interface name!", nsie);
        }
        catch (IllegalLifeCycleException ilce) {
            this.log.log(Level.SEVERE, "Illegal life cycle Exception!", ilce);
        }
    }
}

