/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.model;

import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fscript.ScriptExecutionError;
import org.objectweb.fractal.fscript.diagnostics.Diagnostic;
import org.objectweb.fractal.fscript.diagnostics.Severity;
import org.objectweb.fractal.fscript.interpreter.Context;
import org.objectweb.fractal.fscript.types.PrimitiveType;
import org.objectweb.fractal.fscript.types.Signature;
import org.objectweb.fractal.fscript.types.Type;
import org.ow2.frascati.assembly.factory.api.CompositeManager;
import org.ow2.frascati.assembly.factory.api.ManagerException;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.fscript.procedures.ScaNativeProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaNewAction
implements ScaNativeProcedure {
    public static final String MODEL_ITF_NAME = "frascati-model";
    private FraSCAtiModel model;

    public final String getName() {
        return "sca-new";
    }

    public final Signature getSignature() {
        return new Signature((Type)this.model.getNodeKind("scacomponent"), new Type[]{PrimitiveType.STRING});
    }

    public final boolean isPureFunction() {
        return false;
    }

    private CompositeManager getDomain() {
        try {
            return (CompositeManager)this.model.lookupFc("domain-composite-manager");
        }
        catch (NoSuchInterfaceException e) {
            throw new AssertionError((Object)"Invalid FractalModel component.");
        }
    }

    public final Object apply(List<Object> args, Context ctx) throws ScriptExecutionError {
        Component newComponent;
        String compositeName = (String)args.get(0);
        CompositeManager domain = this.getDomain();
        try {
            newComponent = domain.getComposite(compositeName);
        }
        catch (ManagerException e) {
            Diagnostic err = new Diagnostic(Severity.ERROR, "Unable to instanciate composite " + compositeName);
            throw new ScriptExecutionError(err, (Throwable)e);
        }
        return this.model.createScaComponentNode(newComponent);
    }

    public final String[] listFc() {
        return new String[]{MODEL_ITF_NAME};
    }

    public final void bindFc(String itfName, Object srvItf) throws NoSuchInterfaceException {
        if (!MODEL_ITF_NAME.equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = (FraSCAtiModel)srvItf;
    }

    public final Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (MODEL_ITF_NAME.equals(itfName)) {
            return this.model;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public final void unbindFc(String itfName) throws NoSuchInterfaceException {
        if (!MODEL_ITF_NAME.equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = null;
    }
}

