/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.fscript.model.AbstractAxis;
import org.objectweb.fractal.fscript.model.Model;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.fscript.model.NodeFactory;
import org.ow2.frascati.fscript.model.ScaComponentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaParentAxis
extends AbstractAxis {
    private static Logger logger = Logger.getLogger("org.ow2.frascati.fscript.model.ScaParentAxis");

    public ScaParentAxis(FraSCAtiModel model) {
        super((Model)model, "scaparent", "scacomponent", "scacomponent");
    }

    public final boolean isPrimitive() {
        return true;
    }

    public final boolean isModifiable() {
        return false;
    }

    public final Set<Node> selectFrom(Node source) {
        Component comp = ((ComponentNode)source).getComponent();
        String compName = null;
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException e1) {
            logger.warning(comp + "should have a Name Controller!");
        }
        try {
            SuperController cc = Fractal.getSuperController((Component)comp);
            HashSet<Node> result = new HashSet<Node>();
            for (Component parent : cc.getFcSuperComponents()) {
                try {
                    parent.getFcInterface("sca-component-controller");
                    ScaComponentNode node = ((NodeFactory)this.model).createScaComponentNode(parent);
                    if (compName == null) continue;
                    String parentName = null;
                    try {
                        parentName = Fractal.getNameController((Component)parent).getFcName();
                    }
                    catch (NoSuchInterfaceException e1) {
                        logger.warning(parent + "should have a Name Controller!");
                    }
                    if (parentName == null || parentName.compareTo(compName + "-container") == 0) continue;
                    result.add((Node)node);
                }
                catch (NoSuchInterfaceException e) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (NoSuchInterfaceException e) {
            return Collections.emptySet();
        }
    }
}

