/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.model;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fscript.model.AbstractNode;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.tinfi.control.property.SCAPropertyController;

public class ScaPropertyNode
extends AbstractNode {
    private final String propName;
    private final Component owner;
    private final SCAPropertyController controller;
    private static Logger log = Logger.getLogger("org.ow2.frascati.fscript.model.ScaPropertyNode");

    protected ScaPropertyNode(FraSCAtiModel model, Component owner, SCAPropertyController ctl, String propName) {
        super(model.getNodeKind("scaproperty"));
        Preconditions.checkNotNull((Object)propName);
        this.propName = propName;
        Preconditions.checkNotNull((Object)owner);
        this.owner = owner;
        Preconditions.checkNotNull((Object)ctl);
        this.controller = ctl;
    }

    public final String getName() {
        return this.propName;
    }

    public final Object getValue() {
        return this.controller.getValue(this.propName);
    }

    public final void setValue(Object value) {
        this.controller.setValue(this.propName, value);
    }

    public final Object getProperty(String name) {
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("value".equals(name)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Invalid property name '" + name + "'.");
    }

    public final void setProperty(String name, Object value) {
        this.checkSetRequest(name, value);
        if (!"value".equals(name)) {
            throw new NoSuchElementException(name);
        }
        this.setValue(value);
    }

    public final String toString() {
        String ownerName = "<unnamed>";
        try {
            ownerName = Fractal.getNameController((Component)this.owner).getFcName();
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return "#<scaproperty: " + ownerName + "." + this.getName() + ">";
    }
}

