/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.fscript.procedures;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.bf.BindingFactory;
import org.objectweb.fractal.bf.BindingFactoryException;
import org.objectweb.fractal.bf.connectors.rmi.RmiRegistryCreationException;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.assembly.factory.api.ClassLoaderManager;
import org.ow2.frascati.fscript.model.FraSCAtiModel;
import org.ow2.frascati.fscript.procedures.ScaNativeProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddBinding
implements ScaNativeProcedure {
    public static Logger logger = Logger.getLogger("org.ow2.frascati.fscript.procedures.AddBinding");
    public static final String CLASSLOADER = "classloader";
    public static final String PLUGIN_ID = "plugin.id";
    protected FraSCAtiModel model;

    public final void createBinding(String itfName, Component owner, boolean isScaReference, Map<String, Object> hints) {
        LifeCycleController lcc = null;
        BindingFactory bf = null;
        ClassLoaderManager clm = null;
        try {
            clm = (ClassLoaderManager)this.model.lookupFc("domain-classloader-manager");
        }
        catch (NoSuchInterfaceException nsie) {
            logger.log(Level.SEVERE, "Cannot retrieve the ClassLoder Manager!", nsie);
            return;
        }
        hints.put(CLASSLOADER, clm.getClassLoader());
        try {
            lcc = Fractal.getLifeCycleController((Component)owner);
            lcc.stopFc();
        }
        catch (NoSuchInterfaceException nsie) {
            logger.log(Level.SEVERE, "Error while getting component life cycle controller", nsie);
            return;
        }
        catch (IllegalLifeCycleException ilce) {
            logger.log(Level.SEVERE, "Cannot stop the component!", ilce);
            return;
        }
        try {
            bf = (BindingFactory)this.model.lookupFc("binding-factory");
        }
        catch (NoSuchInterfaceException nsie) {
            logger.log(Level.SEVERE, "Cannot retrieve the Binding Factory!", nsie);
            return;
        }
        try {
            logger.fine("Calling binding factory\n bind: " + Fractal.getNameController((Component)owner).getFcName() + " -> " + itfName);
            if (isScaReference) {
                bf.bind(owner, itfName, hints);
            } else {
                bf.export(owner, itfName, hints);
            }
        }
        catch (BindingFactoryException bfe) {
            logger.log(Level.SEVERE, "Error while binding " + (isScaReference ? "reference" : "service") + ": " + itfName, bfe);
            return;
        }
        catch (NoSuchInterfaceException nsie) {
            logger.log(Level.SEVERE, "Error while getting component name controller", nsie);
            return;
        }
        catch (RmiRegistryCreationException rmie) {
            String msg = rmie.getMessage() + "\nAddress already in use?";
            JOptionPane.showMessageDialog(null, msg);
            logger.log(Level.SEVERE, msg);
            return;
        }
        try {
            lcc.startFc();
        }
        catch (IllegalLifeCycleException ilce) {
            logger.log(Level.SEVERE, "Cannot start the component!", ilce);
        }
    }

    public final String[] listFc() {
        return new String[]{"frascati-model"};
    }

    public final void bindFc(String itfName, Object srvItf) throws NoSuchInterfaceException {
        if (!"frascati-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = (FraSCAtiModel)srvItf;
    }

    public final Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if ("frascati-model".equals(itfName)) {
            return this.model;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public final void unbindFc(String itfName) throws NoSuchInterfaceException {
        if (!"frascati-model".equals(itfName)) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.model = null;
    }
}

