/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.implementation.fractal;

import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.domainmodel.frascati.FractalImplementation;
import org.eclipse.stp.sca.domainmodel.frascati.FrascatiPackage;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Julia;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractImplementationProcessor;
import org.ow2.frascati.util.FrascatiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrascatiImplementationFractalProcessor
extends AbstractImplementationProcessor<FractalImplementation> {
    static {
        System.setProperty("fractal.provider", Julia.class.getCanonicalName());
    }

    protected final void toStringBuffer(FractalImplementation fractalImplementation, StringBuffer sb) {
        sb.append("frascati:implementation.fractal");
        FrascatiImplementationFractalProcessor.append((StringBuffer)sb, (String)"definition", (String)fractalImplementation.getDefinition());
        super.toStringBuffer((Implementation)fractalImplementation, sb);
    }

    protected final void doCheck(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        String fractalImplementationDefinition = fractalImplementation.getDefinition();
        if (fractalImplementationDefinition == null || fractalImplementationDefinition.equals("")) {
            processingContext.error(String.valueOf(this.toString((EObject)fractalImplementation)) + " the attribute 'definition' must be set");
        } else {
            String fractalFile;
            int index = fractalImplementationDefinition.indexOf(40);
            String string = fractalFile = index == -1 ? fractalImplementationDefinition : fractalImplementationDefinition.substring(0, index);
            if (processingContext.getResource(String.valueOf(fractalFile.replace(".", "/")) + ".fractal") == null) {
                processingContext.error(String.valueOf(this.toString((EObject)fractalImplementation)) + " definition '" + fractalFile + "' not found");
            }
        }
        this.checkImplementation((Implementation)fractalImplementation, processingContext);
    }

    protected final void doGenerate(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        this.logFine((EObject)fractalImplementation, "nothing to generate");
    }

    protected final void doInstantiate(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        Component component;
        String definition = fractalImplementation.getDefinition();
        try {
            Class javaClass = processingContext.loadClass(definition);
            org.objectweb.fractal.api.factory.Factory object = (org.objectweb.fractal.api.factory.Factory)javaClass.newInstance();
            component = object.newFcInstance();
        }
        catch (ClassNotFoundException e) {
            try {
                HashMap<String, ClassLoader> context = new HashMap<String, ClassLoader>();
                context.put("classloader", processingContext.getClassLoader());
                Factory f = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
                component = (Component)f.newComponent(definition, context);
            }
            catch (ADLException ae) {
                this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error in the Fractal implementation : " + definition, (Throwable)ae));
                return;
            }
        }
        catch (java.lang.InstantiationException ie) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error when building instance for class " + definition, (Throwable)ie));
            return;
        }
        catch (IllegalAccessException iae) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Could not access class " + definition, (Throwable)iae));
            return;
        }
        catch (InstantiationException ie) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error when building component instance : " + definition, (Throwable)ie));
            return;
        }
        processingContext.putData((Object)fractalImplementation, Component.class, (Object)component);
    }

    public final String getProcessorID() {
        return FrascatiImplementationFractalProcessor.getID((EClass)FrascatiPackage.Literals.FRACTAL_IMPLEMENTATION);
    }
}

