/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.implementation.fractal;

import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.domainmodel.frascati.FractalImplementation;
import org.eclipse.stp.sca.domainmodel.frascati.FrascatiPackage;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Julia;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractImplementationProcessor;
import org.ow2.frascati.implementation.fractal.MyJulia;
import org.ow2.frascati.util.FrascatiException;

public class FrascatiImplementationFractalProcessor
extends AbstractImplementationProcessor<FractalImplementation> {
    private Component juliaBootstrapComponent = null;

    static {
        System.setProperty("fractal.provider", Julia.class.getCanonicalName());
    }

    protected final void toStringBuilder(FractalImplementation fractalImplementation, StringBuilder sb) {
        sb.append("frascati:implementation.fractal");
        FrascatiImplementationFractalProcessor.append((StringBuilder)sb, (String)"definition", (String)fractalImplementation.getDefinition());
        super.toStringBuilder((Implementation)fractalImplementation, sb);
    }

    protected final void doCheck(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        String fractalImplementationDefinition = fractalImplementation.getDefinition();
        if (FrascatiImplementationFractalProcessor.isNullOrEmpty((String)fractalImplementationDefinition)) {
            this.error(processingContext, (EObject)fractalImplementation, new String[]{"The attribute 'definition' must be set"});
        } else {
            String fractalFile;
            int index = fractalImplementationDefinition.indexOf(40);
            String string = fractalFile = index == -1 ? fractalImplementationDefinition : fractalImplementationDefinition.substring(0, index);
            if (processingContext.getResource(String.valueOf(fractalFile.replace(".", "/")) + ".fractal") == null) {
                this.error(processingContext, (EObject)fractalImplementation, new String[]{"Fractal definition '", fractalFile, "' not found"});
            }
        }
        this.checkImplementation((Implementation)fractalImplementation, processingContext);
    }

    protected final void doGenerate(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        this.logFine(processingContext, (EObject)fractalImplementation, "nothing to generate");
    }

    protected final void doInstantiate(FractalImplementation fractalImplementation, ProcessingContext processingContext) throws ProcessorException {
        Component component;
        String definition = fractalImplementation.getDefinition();
        try {
            Class javaClass = processingContext.loadClass(definition);
            org.objectweb.fractal.api.factory.Factory object = (org.objectweb.fractal.api.factory.Factory)javaClass.newInstance();
            component = object.newFcInstance();
        }
        catch (ClassNotFoundException e) {
            if (this.juliaBootstrapComponent == null) {
                try {
                    this.juliaBootstrapComponent = new MyJulia().newFcInstance();
                }
                catch (InstantiationException ie) {
                    this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error into the Fractal implementation : " + definition, (Throwable)ie));
                    return;
                }
            }
            try {
                Factory fractalAdlFactory = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("bootstrap", this.juliaBootstrapComponent);
                context.put("classloader", processingContext.getClassLoader());
                component = (Component)fractalAdlFactory.newComponent(definition, context);
            }
            catch (ADLException ae) {
                this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error into the Fractal implementation : " + definition, (Throwable)ae));
                return;
            }
        }
        catch (java.lang.InstantiationException ie) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error when building instance for class " + definition, (Throwable)ie));
            return;
        }
        catch (IllegalAccessException iae) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Can't access class " + definition, (Throwable)iae));
            return;
        }
        catch (InstantiationException ie) {
            this.severe((FrascatiException)new ProcessorException((Object)fractalImplementation, "Error when building component instance: " + definition, (Throwable)ie));
            return;
        }
        processingContext.putData((Object)fractalImplementation, Component.class, (Object)component);
    }

    public final String getProcessorID() {
        return FrascatiImplementationFractalProcessor.getID((EClass)FrascatiPackage.Literals.FRACTAL_IMPLEMENTATION);
    }
}

