/**
 * OW2 FraSCAti: SCA OSGi Implementation
 * Copyright (C) 2010 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 *
 */

package org.ow2.frascati.implementation.osgi;

import org.objectweb.fractal.juliac.osgi.FCOOCtrlSourceCodeGenerator;

import org.ow2.frascati.component.factory.impl.AbstractMembraneProvider;

/**
 * OW2 FraSCAti OSGi Juliac generator class provider.
 *
 * @author <a href="mailto:philippe.merle@inria.fr">Philippe Merle</a>
 * @version 1.3
 */
public class OsgiJuliacGeneratorClassProvider
     extends AbstractMembraneProvider {

  //---------------------------------------------------------------------------
  // Internal state.
  // --------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  // Internal methods.
  // --------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  // Public methods.
  // --------------------------------------------------------------------------

  /**
   * @see org.ow2.frascati.component.factory.api.MembraneProvider#getMembraneDescription()
   */
  public final String[] getMembraneNames() {
    return new String[] { "osgiPrimitive" };
  }

  /**
   * @see org.ow2.frascati.component.factory.api.MembraneProvider#getMembraneDescription()
   */
  public final String getMembraneDescription() {
    return "Tinfi OSGi";
  }

  /**
   * @see org.ow2.frascati.component.factory.api.MembraneProvider#getMembraneClass()
   */
  public final Class<?> getMembraneClass() {
    return FCOOCtrlSourceCodeGenerator.class;
  }

}
