/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.implementation.spring;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.SpringImplementation;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.type.ComponentType;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractCompositeBasedImplementationProcessor;
import org.ow2.frascati.implementation.spring.ParentApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaImplementationSpringProcessor
extends AbstractCompositeBasedImplementationProcessor<SpringImplementation, ClassPathXmlApplicationContext> {
    protected final void toStringBuffer(SpringImplementation springImplementation, StringBuffer sb) {
        sb.append("sca:implementation.spring");
        ScaImplementationSpringProcessor.append((StringBuffer)sb, (String)"location", (String)springImplementation.getLocation());
        super.toStringBuffer((Implementation)springImplementation, sb);
    }

    protected final void doCheck(SpringImplementation springImplementation, ProcessingContext processingContext) throws ProcessorException {
        String springImplementationLocation = springImplementation.getLocation();
        if (springImplementationLocation == null || springImplementationLocation.equals("")) {
            processingContext.error(this.toString((EObject)springImplementation) + " the attribute 'location' must be set");
        } else if (processingContext.getResource(springImplementationLocation) == null) {
            processingContext.error(this.toString((EObject)springImplementation) + " location '" + springImplementationLocation + "' not found");
        }
        this.checkImplementation((Implementation)springImplementation, processingContext);
    }

    protected final void doInstantiate(SpringImplementation springImplementation, ProcessingContext processingContext) throws ProcessorException {
        String springLocation = springImplementation.getLocation();
        this.log.finer("Create an SCA component with the Spring implementation " + springLocation + " and the Fractal component type " + ((ComponentType)processingContext.getData((Object)springImplementation, ComponentType.class)).toString());
        Component component = this.createFractalComposite((Implementation)springImplementation, processingContext);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{springLocation}, (ApplicationContext)new ParentApplicationContext(component));
        context.setClassLoader(processingContext.getClassLoader());
        this.connectFractalComposite((Implementation)springImplementation, processingContext, context);
    }

    protected final Object getService(ClassPathXmlApplicationContext context, String name, Class<?> interfaze) throws Exception {
        return context.getBean(name);
    }

    protected final void setReference(ClassPathXmlApplicationContext context, String name, Object delegate, Class<?> interfaze) throws Exception {
    }

    public final String getProcessorID() {
        return ScaImplementationSpringProcessor.getID((EClass)ScaPackage.Literals.SPRING_IMPLEMENTATION);
    }
}

