/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.wsdl;

import com.sun.xml.bind.api.impl.NameConverter;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.component.factory.api.MembraneGeneration;
import org.ow2.frascati.util.AbstractLoggeable;
import org.ow2.frascati.util.FrascatiException;
import org.ow2.frascati.wsdl.WsdlCompiler;

@Scope(value="COMPOSITE")
public class WsdlCompilerCXF
extends AbstractLoggeable
implements WsdlCompiler {
    @Property(name="target-directory")
    private String targetDirectory = "wsdl2java";
    @Reference(name="membrane-generation")
    private MembraneGeneration membraneGeneration;
    private WSDLReader wsdlReader;
    private boolean addJavaSourceCalled = false;
    private Map<String, String> alreadyCompiledWsdlFiles = new HashMap<String, String>();

    @Init
    public final void initialize() throws FrascatiException {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            this.wsdlReader = wsdlFactory.newWSDLReader();
            this.wsdlReader.setFeature("javax.wsdl.verbose", false);
            this.wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        }
        catch (WSDLException we) {
            this.severe(new FrascatiException("Could not initialize WSDLReader", (Throwable)we));
        }
    }

    public final Definition readWSDL(String wsdlUri) throws WSDLException {
        return this.wsdlReader.readWSDL(wsdlUri);
    }

    public final void compileWSDL(String wsdlUri, ProcessingContext processingContext) throws Exception {
        if (this.alreadyCompiledWsdlFiles.get(wsdlUri) != null) {
            this.log.info("WSDL '" + wsdlUri + "' already compiled.");
            return;
        }
        this.alreadyCompiledWsdlFiles.put(wsdlUri, wsdlUri);
        try {
            Definition definition = this.readWSDL(wsdlUri);
            String objectFactoryClassName = NameConverter.standard.toPackageName(definition.getTargetNamespace()) + ".ObjectFactory";
            processingContext.loadClass(objectFactoryClassName);
            this.log.info("WSDL '" + wsdlUri + "' already compiled.");
            return;
        }
        catch (ClassNotFoundException cnfe) {
            String outputDirectory = this.membraneGeneration.getOutputDirectory() + '/' + this.targetDirectory;
            String[] params = new String[]{"-d", outputDirectory, wsdlUri};
            this.log.info("Compiling WSDL '" + wsdlUri + "' into '" + outputDirectory + "'...");
            try {
                new WSDLToJava(params).run(new ToolContext());
            }
            catch (Exception exc) {
                this.log.warning("Impossible to compile WSDL '" + wsdlUri + "'.");
                throw exc;
            }
            this.log.info("WSDL '" + wsdlUri + "' compiled.");
            if (!this.addJavaSourceCalled) {
                this.membraneGeneration.addJavaSource(outputDirectory);
                this.addJavaSourceCalled = true;
            }
            return;
        }
    }
}

