/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.wsdl;

import com.sun.xml.bind.api.impl.NameConverter;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.sca.Interface;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.WSDLPortType;
import org.osoa.sca.annotations.Reference;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractInterfaceProcessor;
import org.ow2.frascati.util.FrascatiException;
import org.ow2.frascati.wsdl.WsdlCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaInterfaceWsdlProcessor
extends AbstractInterfaceProcessor<WSDLPortType> {
    @Reference(name="wsdl-compiler")
    private WsdlCompiler wsdlCompiler;

    protected final void toStringBuilder(WSDLPortType wsdlPortType, StringBuilder sb) {
        sb.append("sca:interface.wsdl");
        ScaInterfaceWsdlProcessor.append((StringBuilder)sb, (String)"interface", (String)wsdlPortType.getInterface());
        super.toStringBuilder((Interface)wsdlPortType, sb);
    }

    protected final void doCheck(WSDLPortType wsdlPortType, ProcessingContext processingContext) throws ProcessorException {
        String wsdlInterface = wsdlPortType.getInterface();
        if (wsdlInterface == null || wsdlInterface.equals("")) {
            this.error(processingContext, (EObject)wsdlPortType, new String[]{"The attribute 'interface' must be set"});
        } else {
            PortType portType = this.getPortType(wsdlPortType, processingContext, "interface", wsdlInterface);
            if (portType != null) {
                QName qname = portType.getQName();
                String localPart = qname.getLocalPart();
                String javaInterface = NameConverter.standard.toPackageName(qname.getNamespaceURI()) + '.' + Character.toUpperCase(localPart.charAt(0)) + localPart.substring(1);
                this.log.info("The Java interface for '" + wsdlInterface + "' is " + javaInterface);
                Class clazz = null;
                try {
                    clazz = processingContext.loadClass(javaInterface);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                this.storeJavaInterface((Interface)wsdlPortType, processingContext, javaInterface, clazz);
            }
        }
        wsdlInterface = wsdlPortType.getCallbackInterface();
        if (wsdlInterface != null) {
            this.getPortType(wsdlPortType, processingContext, "callback interface", wsdlInterface);
        }
    }

    private PortType getPortType(WSDLPortType wsdlPortType, ProcessingContext processingContext, String what, String scaWsdlInterface) throws ProcessorException {
        this.logDo(processingContext, (EObject)wsdlPortType, "check the WSDL " + what + " " + scaWsdlInterface);
        PortType portType = null;
        String wsdlUri = null;
        String portTypeName = null;
        int idx = scaWsdlInterface.indexOf("#wsdl.interface(");
        if (idx != -1 && scaWsdlInterface.endsWith(")")) {
            wsdlUri = scaWsdlInterface.substring(0, idx);
            portTypeName = scaWsdlInterface.substring(idx + "#wsdl.interface(".length(), scaWsdlInterface.length() - 1);
        }
        if (wsdlUri == null || portTypeName == null) {
            this.error(processingContext, (EObject)wsdlPortType, new String[]{"Invalid 'interface' value, must be uri#wsdl.interface(portType)"});
        } else {
            URL url = processingContext.getResource(wsdlUri);
            if (url != null) {
                wsdlUri = url.toString();
            }
            Definition definition = null;
            try {
                definition = this.wsdlCompiler.readWSDL(wsdlUri);
            }
            catch (WSDLException we) {
                processingContext.error(this.toString((EObject)wsdlPortType) + " " + wsdlUri + ": " + we.getMessage());
                return null;
            }
            portType = definition.getPortType(new QName(definition.getTargetNamespace(), portTypeName));
            if (portType == null) {
                this.error(processingContext, (EObject)wsdlPortType, new String[]{"Unknown port type name '", portTypeName, "'"});
                return null;
            }
        }
        this.logDone(processingContext, (EObject)wsdlPortType, "check the WSDL " + what + " " + scaWsdlInterface);
        return portType;
    }

    protected final void doGenerate(WSDLPortType wsdlPortType, ProcessingContext processingContext) throws ProcessorException {
        if (ScaInterfaceWsdlProcessor.getClass((Interface)wsdlPortType, (ProcessingContext)processingContext) == null) {
            int idx;
            String scaWsdlInterface = wsdlPortType.getInterface();
            String wsdlUri = scaWsdlInterface.substring(0, idx = scaWsdlInterface.indexOf("#wsdl.interface("));
            URL url = processingContext.getResource(wsdlUri);
            if (url != null) {
                wsdlUri = url.toString();
            }
            try {
                this.wsdlCompiler.compileWSDL(wsdlUri, processingContext);
            }
            catch (Exception exc) {
                this.severe((FrascatiException)new ProcessorException((Object)"Error when compiling WSDL", (Throwable)exc));
                return;
            }
        }
    }

    public final String getProcessorID() {
        return ScaInterfaceWsdlProcessor.getID((EClass)ScaPackage.Literals.WSDL_PORT_TYPE);
    }
}

