/***
 * OW2 FraSCAti Introspection
 * Copyright (C) 2008-2011 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Christophe Demarey
 */
package org.ow2.frascati.remote.introspection;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

import org.osoa.sca.annotations.Service;

/**
 * This interface is used to deploy SCA applications (contributions) remotely.
 */
@Service
public interface Deployment {
	/**
	 * Deploy a contribution on the FraSCAti runtime.
	 * 
	 * @param contribution A zip file compliant with the SCA contribution specification encoded as a Base64 String.
	 * @return 0 if the deployment succeed, else -1.
	 */
	@POST
    @Path("/deploy/")
    public int deploy(@FormParam("contribution") String encodedContribution);  
}
