/***
 * OW2 FraSCAti Introspection
 * Copyright (C) 2008-2010 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Christophe Demarey
 */
package org.ow2.frascati.remote.introspection;

import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.osoa.sca.annotations.Service;
import org.ow2.frascati.remote.introspection.resources.Component;
import org.ow2.frascati.remote.introspection.resources.Port;

/**
 * This interface is used to expose / introspect an SCA runtime remotely.
 */
@Service
public interface RemoteScaDomain {
    /**
     * Get the list of top-level composites running in this SCA domain.
     * @return the list of composite.
     */
    @GET
    @Path("/components")
    @Produces({"application/xml", "application/json"})
    Collection<Component> getDomainComposites();
    
    /**
     * Get full information on the component given as parameter. 
     * @param id The full component id (ex: /a/b/d)
     * @return a Component resource.
     */
    @GET
    @Path("/component/{id:.*}")
    @Produces({"application/xml", "application/json"})
    Component getComponent(@PathParam("id") String id);

    /**
     * Get children of the component given as parameter. 
     * @param id The full component id (ex: /a/b/d)
     * @return a list of Component resources.
     */
    @GET
    @Path("/component/{id:.*}/subcomponents")
    @Produces({"application/xml", "application/json"})
    Collection<Component> getSubComponents(@PathParam("id") String id);
    
    @GET
    @Path("/port/{id:.*}")
    @Produces({"application/xml", "application/json"})
    Port getInterface(@PathParam("id") String id);

    // ...
}
