/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.property.jaxb;

import com.sun.xml.bind.api.impl.NameConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.stp.sca.SCAPropertyBase;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.Processor;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractPropertyTypeProcessor;
import org.ow2.frascati.util.FrascatiException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScaPropertyTypeJaxbProcessor
extends AbstractPropertyTypeProcessor {
    private Map<Class<?>, Unmarshaller> cacheOfUnmarshallers = new HashMap();

    protected final void doCheck(SCAPropertyBase property, ProcessingContext processingContext) throws ProcessorException {
        QName propertyType = (QName)processingContext.getData((Object)property, QName.class);
        if (propertyType == null) {
            return;
        }
        String packageName = NameConverter.standard.toPackageName(propertyType.getNamespaceURI());
        try {
            this.log.fine("Try to load " + packageName + ".package-info.class");
            processingContext.loadClass(packageName + ".package-info");
            this.log.fine(packageName + ".package-info.class found.");
            processingContext.putData((Object)property, Processor.class, (Object)this);
            this.doComplete(property, processingContext);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.fine("No " + packageName + ".package-info.class found.");
            return;
        }
    }

    protected final void doComplete(SCAPropertyBase property, ProcessingContext processingContext) throws ProcessorException {
        Object computedPropertyValue;
        Class packageInfoClass;
        Node node;
        QName propertyType = (QName)processingContext.getData((Object)property, QName.class);
        HashMap<String, List<SCAPropertyBase>> options = new HashMap<String, List<SCAPropertyBase>>();
        options.put("ROOT_OBJECTS", Collections.singletonList(property));
        Document document = ((XMLResource)property.eResource()).save(null, options, null);
        for (node = document.getChildNodes().item(0).getChildNodes().item(0); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node == null) {
            processingContext.error(this.toString((EObject)property) + " - no XML element");
            return;
        }
        String packageName = NameConverter.standard.toPackageName(propertyType.getNamespaceURI());
        try {
            packageInfoClass = processingContext.loadClass(packageName + ".package-info");
        }
        catch (ClassNotFoundException cnfe) {
            this.severe((FrascatiException)new ProcessorException((Object)property, "JAXB package info for " + this.toString((EObject)property) + " not found", (Throwable)cnfe));
            return;
        }
        Unmarshaller unmarshaller = this.cacheOfUnmarshallers.get(packageInfoClass);
        if (unmarshaller == null) {
            JAXBContext jaxbContext;
            try {
                jaxbContext = JAXBContext.newInstance((String)packageName, (ClassLoader)processingContext.getClassLoader());
            }
            catch (JAXBException je) {
                this.severe((FrascatiException)new ProcessorException((Object)property, "create JAXB context failed for " + this.toString((EObject)property), (Throwable)je));
                return;
            }
            try {
                unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (JAXBException je) {
                this.severe((FrascatiException)new ProcessorException((Object)property, "create JAXB unmarshaller failed for " + this.toString((EObject)property), (Throwable)je));
                return;
            }
            this.cacheOfUnmarshallers.put(packageInfoClass, unmarshaller);
        }
        try {
            computedPropertyValue = unmarshaller.unmarshal((Node)((Element)node));
        }
        catch (JAXBException je) {
            processingContext.error(this.toString((EObject)property) + " - XML unmarshalling error: " + je.getMessage());
            return;
        }
        processingContext.putData((Object)property, Object.class, computedPropertyValue);
    }
}

